<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
<!DOCTYPE database SYSTEM "../dtd/database.dtd">

<database package="core.book" name="bookstore" defaultIdMethod="native">

  <table name="book" description="Book Table">
    <column
      name="id"
      required="true"
      primaryKey="true"
	  autoIncrement="true"
      type="INTEGER"
      description="Book Id"/>
    <column
      name="title"
      required="true"
      type="VARCHAR"
      size="255"
      description="Book Title"/>
    <column
      name="isbn"
      required="true"
      type="VARCHAR"
      size="24"
      phpName="ISBN"
      description="ISBN Number"/>
    <column
      name="publisher_id"
      required="false"
      type="INTEGER"
      description="Foreign Key Publisher"/>
    <column
      name="author_id"
      required="false"
      type="INTEGER"
      description="Foreign Key Author"/>
    <foreign-key foreignTable="publisher" onDelete="SETNULL">
      <reference
        local="publisher_id"
        foreign="id"/>
    </foreign-key>
    <foreign-key foreignTable="author" onDelete="SETNULL">
      <reference
        local="author_id"
        foreign="id"/>
    </foreign-key>
    <validator column="title" translate="none">
      <rule
        name="unique"
        message="Book title already in database." />
      <rule
        name="minLength"
        value="10"
        message="Book title must be more than ${value} characters long."/>
      <rule
        name="maxLength"
        value="255"
        message="Book title must not be longer than ${value} characters."/>
    </validator>
    <validator column="isbn" translate="none">
      <rule
         name="notMatch"
         value="/[^\d-]+/"
         message="The ISBN contains invalid characters." />
    </validator>
  </table>

</database>
