<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
<!DOCTYPE database SYSTEM "../dtd/database.dtd">

<database package="core.review" name="bookstore" defaultIdMethod="native">

  <table name="review" description="Book Review">
    <column
      name="id"
      required="true"
      primaryKey="true"
	  autoIncrement="true"
      type="INTEGER"
      description="Author Id"/>
    <column
      name="reviewed_by"
      required="true"
      type="VARCHAR"
      size="128"
      description="Reviewer Name"/>
	<column
      name="review_date"
      required="true"
      type="DATE"
	  default="01/01/2001"
      description="Date of Review"/>
	<column
      name="recommended"
      required="true"
      type="BOOLEAN"
      description="Does reviewer recommend book?"/>
	<column
      name="status"
      type="VARCHAR"
      size="8"
      description="The status of this review."/>
	<column
	  name="book_id"
	  required="true"
	  type="INTEGER"
	  description="Book ID for this review"/>
	<foreign-key foreignTable="book" onDelete="CASCADE">
      <reference
        local="book_id"
        foreign="id"/>
    </foreign-key>
	<validator column="reviewed_by" translate="none">
		<rule
			name="required"
			message="The reviewed by field is required."/>
	</validator>
   <validator column="status" translate="none">
      <rule
         name="validValues"
         value="new|reviewed|archived"
         message="Invalid status. (new, reviewed, archived)" />
	</validator>
  </table>

</database>
