ALTER TABLE `clients` MODIFY COLUMN `state` varchar(20) default NULL; 
ALTER TABLE `clients` MODIFY COLUMN `shiptostate` varchar(20) default NULL;
ALTER TABLE `invoices` MODIFY COLUMN `state` varchar(20) default NULL;
UPDATE tablecolumns SET `column` = 'lineitems.unitprice', footerquery = 'sum(lineitems.unitprice)', format='currency' WHERE name="unit price" and tabledefid=5;
DELETE FROM tablecolumns WHERE tabledefid=2 or tabledefid=3 or tabledefid = 4 or tabledefid = 5 OR tabledefid = 6 OR tabledefid = 7 OR tabledefid = 8 OR tabledefid = 18 OR tabledefid = 22 OR tabledefid = 25 OR tabledefid = 300 OR tabledefid = 301 OR tabledefid = 302;
UPDATE tabledefs SET querytable='(((invoices INNER JOIN clients ON invoices.clientid=clients.id) INNER JOIN invoicestatuses ON invoices.statusid=invoicestatuses.id) LEFT JOIN paymentmethods ON invoices.paymentmethodid = paymentmethods.id)', defaultwhereclause ='invoices.type+0<3 OR (invoices.type = \'Invoice\' AND invoices.totalti != invoices.amountpaid)' WHERE id =3;
DELETE FROM tablefindoptions WHERE tabledefid=3;
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Orders - Ready To Post','invoices.type = \'Order\' AND invoices.readytopost =1',8,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Orders - No Payment','invoices.type = \'Order\' AND invoices.paymentmethodid IS NULL or invoices.paymentmethodid = 0',9,20);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices - Today','invoices.type=\"Invoice\" and invoices.invoicedate=curdate()',11,20);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices - Yesterday','invoices.type=\"Invoice\" and invoices.invoicedate=date_sub(curdate(),INTERVAL 1 DAY)',12,20);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices - This Month','invoices.type=\"Invoice\" and year(invoicedate)=year(curdate()) and month(invoicedate)=month(curdate())',15,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Orders','invoices.type=\"Order\"',1,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Orders/Invoices - Unpaid','invoices.type != \'Quote\' AND invoices.type != \'VOID\' AND invoices.amountpaid != invoices.totalti',7,20);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices','invoices.type=\"Invoice\"',10,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Quotes','invoices.type=\"Quote\"',17,20);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Voided Records','invoices.type=\"VOID\"',18,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'All Records','invoices.id != 0',19,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices - Last Month','invoices.type=\"Invoice\" and year(invoicedate)=year(date_sub(curdate(),INTERVAL 1 MONTH)) and month(invoicedate)=month(date_sub(curdate(),INTERVAL 1 MONTH))',16,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices - This Week','invoices.type=\"Invoice\" and year(invoicedate)=year(curdate()) and week(invoicedate)=week(curdate())',13,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Invoices - Last Week','invoices.type=\"Invoice\" and year(invoicedate)=year(date_sub(curdate(),INTERVAL 7 DAY)) and week(invoicedate)=week(date_sub(curdate(),INTERVAL 7 DAY))',14,30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (3,'Orders - Today','invoices.type=\"Order\" and invoices.orderdate=curdate()',6,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'type','clients.type','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'name / company','if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)','left','',2,'',0,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'city','clients.city','left','',4,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'state','clients.state','left','',5,'',0,'',NULL,10);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'zip','clients.postalcode','left','',6,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'e-mail','clients.email','left','',3,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (2,'has credit','clients.hascredit','center','',1,'',0,'','boolean',80);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'id','invoices.id','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'type','invoices.type','left','',2,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'status','invoicestatuses.name','left','',3,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'date','if(invoices.type=\"Invoice\",invoices.invoicedate,invoices.orderdate)','left','',5,'',0,'','date',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'client name / company','concat(\"<strong>\",if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company),\"</strong>\")','left','',6,NULL,0,'100%','noencoding',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'total','if(invoices.type!=\"VOID\",invoices.totalti,\"-----\")','right','sum(if(invoices.type!=\"VOID\",invoices.totalti,0))',8,'if(invoices.type!=\"VOID\",invoices.totalti,0)',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'due','if(invoices.type!=\"VOID\",invoices.totalti-invoices.amountpaid,\"-----\")','right','sum(if(invoices.type!=\"VOID\",(invoices.totalti-invoices.amountpaid),0))',9,'if(invoices.type!=\"VOID\",invoices.totalti-invoices.amountpaid,0)',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'web','invoices.weborder','center','',4,'',0,'','boolean',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'RTP','invoices.readytopost','center','',1,'',0,'','boolean',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (3,'payment','paymentmethods.name','left','',7,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (4,'part number','products.partnumber','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (4,'name','products.partname','left','',1,'',1,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (4,'status','products.status','left','',3,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (4,'unit price','products.unitprice','right','',4,'',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (4,'type','products.type','left','',2,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'id','lineitems.id','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'invoice id','lineitems.invoiceid','left','',1,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'part #','products.partnumber','left','',4,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'name','products.partname','left','',5,'',1,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'unit price','lineitems.unitprice','right','sum(lineitems.unitprice)',6,'lineitems.unitprice',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'qty','format(lineitems.quantity,2)','center','format(sum(lineitems.quantity),2)',7,'lineitemd.quantity',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'price ext.','lineitems.unitprice*lineitems.quantity','right','sum(lineitems.unitprice*lineitems.quantity)',8,'',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'cost ext.','lineitems.unitcost*lineitems.quantity','right','sum(lineitems.unitcost*lineitems.quantity)',9,'',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'total wt.','format((lineitems.unitweight*lineitems.quantity),2)','right','format(sum(lineitems.unitweight*lineitems.quantity),2)',11,'lineitems.unitweight*lineitems.quantity',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'type','invoices.type','left','',2,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'date','if(invoices.type=\"Invoice\",invoices.invoicedate,invoices.orderdate)\r\n','left','',3,'',1,'','date',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (5,'tax','lineitems.taxable','center','',10,'',0,'','boolean',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (6,'id','tax.id','center','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (6,'name','concat(\"<strong>\",tax.name,\"</strong>\")','left','',1,NULL,0,'','noencoding',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (6,'percentage','concat(tax.percentage,\"%\")','left','',2,'tax.percentage',0,'98%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (7,'id','productcategories.id','center','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (7,'name','productcategories.name','left','',1,'',0,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (7,'date created','productcategories.creationdate','left','',2,'productcategories.creationdate',0,'','datetime',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (8,'name','childproducts.partname','left','',1,'',1,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (8,'part number','childproducts.partnumber','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (18,'id','clients.id','center','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (18,'type','if(clients.type=\"prospect\",\"<span style=\'color:red;\'>P</span>\",\"<b>C</b>\")','left','',1,NULL,0,'','noencoding',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (18,'company / name','if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)','left','',2,'',1,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (18,'city','clients.city','left','',3,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (18,'state','clients.state','center','',4,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (18,'postal code','clients.postalcode','left','',5,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (22,'name','clientemailprojects.name','left','',0,'',0,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (22,'last run','clientemailprojects.lastrun','right','',1,'',0,'','datetime',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (25,'amount/percent','discounts.value','right','',2,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (25,'type','discounts.type','left','',1,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (25,'name','discounts.name','left','',0,'',0,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (300,'name','shippingmethods.name','left','',1,'',0,'99%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (300,'estimate','shippingmethods.canestimate','center','',2,'',0,'','boolean',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (300,'priority','shippingmethods.priority','right','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (301,'name','paymentmethods.name','left','',1,'',0,'99%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (301,'type','paymentmethods.type','left','',2,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (301,'id','paymentmethods.id','center','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (301,'priority','paymentmethods.priority','center','',3,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (301,'online process','paymentmethods.onlineprocess','center','',4,'',0,'','boolean',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (302,'name','invoicestatuses.name','left','',0,'',1,'99%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (302,'priority','invoicestatuses.priority','right','',1,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (302,'inactive','invoicestatuses.inactive','center','',2,'',0,'','boolean',0);
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('200', 'Client', '', '0', '0', 1, 1, NOW(), NOW(), '20');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('201', 'Quick View', 'modules/bms/quickview.php', '200', '0', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('202', 'Clients', 'search.php?id=2', '200', '10', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('203', 'Check for Duplicates', 'search.php?id=18', '200', '20', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('204', 'Sales', '', '0', '1', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('205', 'Sales Orders', 'search.php?id=3', '204', '10', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('206', 'Item Analysis', 'search.php?id=5', '204', '55', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('207', 'Discounts', 'search.php?id=25', '204', '40', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('208', 'Tax Areas', 'search.php?id=6', '204', '70', 1, 1, NOW(), NOW(), '50');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('209', 'Product', '', '0', '2', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('210', 'Products', 'search.php?id=4', '209', '0', 1, 1, NOW(), NOW(), '10');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('211', 'Product Categories', 'search.php?id=7', '209', '1', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('212', 'Prerequisites', 'search.php?id=8', '209', '2', 1, 1, NOW(), NOW(), '20');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('213', 'Shipping Methods', 'search.php?id=300', '204', '80', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('214', 'Payment Methods', 'search.php?id=301', '204', '90', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('215', '----', '', '204', '50', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('216', 'Invoice Statuses', 'search.php?id=302', '204', '80', 1, 1, NOW(), NOW(), '30');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('262', 'Email Projects', 'search.php?id=22', '200', '100', 1, 1, NOW(), NOW(), '-100');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('240', 'AR Items', 'search.php?id=303', '204', '20', 1, 1, NOW(), NOW(), '0');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('241', 'Receipts', 'search.php?id=304', '204', '30', 1, 1, NOW(), NOW(), '80');
DELETE FROM `tablegroupings` WHERE tabledefid=2 or tabledefid=3 or tabledefid = 4 or tabledefid = 5 OR tabledefid = 6 OR tabledefid = 7 OR tabledefid = 8 OR tabledefid = 18 OR tabledefid = 22 OR tabledefid = 25 OR tabledefid = 300 OR tabledefid = 301 OR tabledefid = 302;
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES (2,'clients.type',1,1,'',0);
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES (3,'concat(invoices.type,\"s\")',1,1,'',0);
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES (4,'productcategories.name',1,1,'',0);
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES (8,'concat(products.partnumber,\' - \',products.partname)',1,1,'',0);
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES (22,'if(clientemailprojects.userid=0, \"global\", concat( users.firstname,\" \", users.lastname))',1,1,'',0);
INSERT INTO `settings` (`name`,`value`) VALUES ('default_clienttype','prospect');
INSERT INTO `settings` (`name`,`value`) VALUES ('default_hascredit','0');
INSERT INTO `settings` (`name`,`value`) VALUES ('default_creditlimit','0');
ALTER TABLE `clients` ADD COLUMN `hascredit` TINYINT UNSIGNED NOT NULL DEFAULT 0;
ALTER TABLE `clients` ADD COLUMN `creditlimit` REAL;
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (300,'credit', 'clients entry', 'modules/bms/clients_credit.php', 15, 0, 0, 'Credit Limits/History', NULL, 1, NOW(), 1, NOW());
ALTER TABLE `clients` MODIFY COLUMN `firstname` VARCHAR(64) NOT NULL DEFAULT '';
ALTER TABLE `clients` MODIFY COLUMN `lastname` VARCHAR(64) NOT NULL DEFAULT '';
ALTER TABLE `clients` MODIFY COLUMN `company` VARCHAR(128) NOT NULL DEFAULT '';
ALTER TABLE `invoicestatuses` ADD COLUMN `setreadytopost` TINYINT UNSIGNED NOT NULL DEFAULT 0;
ALTER TABLE `invoices` ADD COLUMN `readytopost` TINYINT UNSIGNED NOT NULL DEFAULT 0;
UPDATE `invoicestatuses` SET `name`="Shipped", `setreadytopost`=1 WHERE id = 4;
UPDATE `invoices` SET `readytopost`=1 WHERE `type`="Invoice";
CREATE TABLE `aritems` (`id` int(10) unsigned NOT NULL AUTO_INCREMENT, `clientid` int(10) unsigned NOT NULL, `type` ENUM('invoice','credit','service charge') NOT NULL, `status` ENUM('open','closed') NOT NULL, `itemdate` DATE NOT NULL, `relatedid` int(10) unsigned default NULL, `amount` double NOT NULL default '0', `paid` double NOT NULL default '0', `aged1` tinyint(3) unsigned NOT NULL default '0', `aged2` tinyint(3) unsigned NOT NULL default '0', `aged3` tinyint(3) unsigned NOT NULL default '0', `title` varchar(255) default NULL, `posted` tinyint(3) unsigned NOT NULL default '0', `createdby` int(10) unsigned NOT NULL, `creationdate` datetime NOT NULL, `modifiedby` int(10) unsigned default NULL, `modifieddate` timestamp NOT NULL, PRIMARY KEY  (`id`));
CREATE TABLE `receipts` (`id` int(10) unsigned NOT NULL AUTO_INCREMENT, `clientid` int(10) unsigned NOT NULL, `amount` double NOT NULL default '0', `receiptdate` date NOT NULL, `status` enum('open','collected') NOT NULL default 'open', `readytopost` tinyint(3) unsigned NOT NULL default '0', `posted` tinyint(3) unsigned NOT NULL default '0', `paymentmethodid` int(10) unsigned NOT NULL default '0', `ccnumber` varchar(64) default NULL, `ccexpiration` varchar(10) default NULL, `ccverification` varchar(4) default NULL, `bankname` varchar(64) default NULL, `checkno` varchar(32) default NULL, `routingnumber` int(10) unsigned default NULL,`accountnumber` int(10) unsigned default NULL, `transactionid` varchar(64) default NULL, `paymentother` varchar(128) default NULL, `memo` text, `createdby` int(11) NOT NULL default '0', `creationdate` datetime NOT NULL default '0000-00-00 00:00:00', `modifiedby` int(10) unsigned default NULL, `modifieddate` timestamp NOT NULL, PRIMARY KEY  (`id`));
INSERT INTO `settings` (`name`,`value`) VALUES ('term1_days','30');
INSERT INTO `settings` (`name`,`value`) VALUES ('term1_percentage','10');
INSERT INTO `settings` (`name`,`value`) VALUES ('term2_days','60');
INSERT INTO `settings` (`name`,`value`) VALUES ('term2_percentage','15');
INSERT INTO `settings` (`name`,`value`) VALUES ('term3_days','90');
INSERT INTO `settings` (`name`,`value`) VALUES ('term3_percentage','20');
CREATE TABLE `receiptitems` (`id` int(10) unsigned NOT NULL AUTO_INCREMENT, `receiptid` int(10) unsigned NOT NULL, `aritemid` int(10) unsigned NOT NULL, `applied` double NOT NULL default '0', `discount` double NOT NULL default '0', `taxadjustment` double NOT NULL default '0', PRIMARY KEY  (`id`));
INSERT INTO `roles` (`id`, `name`, `description`, `inactive`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (80,'accounts receivable','Access to AR items, and receipts',0,1,NOW(),1,NOW());
INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('receiptother','loss (write-off)');
INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('receiptother','error');
INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('receiptother','correction');
INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('receiptother','transfer');
INSERT INTO `reports` (`name`, `type`, `tabledefid`, `displayorder`, `roleid`, `reportfile`, `description`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('Client Statements', 'PDF Report', '303', '10', '80', 'modules/bms/report/aritems_clientstatement.php', 'Client AR statement balances and activity.', 1, NOW(), 1, NOW());
INSERT INTO `reports` (`name`, `type`, `tabledefid`, `displayorder`, `roleid`, `reportfile`, `description`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('Summary', 'report', '303', '10', '80', 'modules/bms/report/aritems_summary.php', 'Items grouped and totaled by clients, with grand totals.', 1, NOW(), 1, NOW());
INSERT INTO `reports` (`name`, `type`, `tabledefid`, `displayorder`, `roleid`, `reportfile`, `description`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('Payment Type Totals', 'report', '304', '10', '80', 'modules/bms/report/receipts_pttotals.php', 'Totals grouped by payment method.', 1, NOW(), 1, NOW());
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('303', 'AR Items', 'table', '2', 'aritems', '(aritems INNER JOIN clients ON aritems.clientid = clients.id)', 'modules/bms/aritems_view.php', '0', 'NA', '0', '0', '-100', '-100', 'NA', 'aritems.posted=1 AND aritems.status = \'open\'', 'aritems.itemdate, aritems.status, aritems.id', NULL, NULL, NULL, 1, NOW(), 1, NOW());
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('304', 'Receipts', 'table', '2', 'receipts', '((receipts INNER JOIN clients ON receipts.clientid = clients.id) LEFT JOIN paymentmethods ON receipts.paymentmethodid = paymentmethods.id)', 'modules/bms/receipts_addedit.php', '80', 'modules/bms/receipts_addedit.php', '80', '80', '-100', '-100', 'delete', 'receipts.posted=0', 'receipts.receiptdate', NULL, NULL, NULL, 1, NOW(), 1, NOW());
UPDATE tabledefs SET `displayname` = 'Clients', `defaultsortorder` = 'if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)' WHERE id=2;
UPDATE tabledefs SET `displayname` = 'Sales Orders' WHERE id=3;
UPDATE tabledefs SET `displayname` = 'Client Duplicates' WHERE id=18;
UPDATE tabledefs SET `displayname` = 'Discounts' WHERE id=25;
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'type','aritems.type','left','',1,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'date','aritems.itemdate','left','',3,'',0,'','date',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'client','if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)','left','',4,'',1,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'doc amt','aritems.amount','right','SUM(aritems.amount)',5,'',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'amt due','aritems.amount-aritems.paid','right','SUM(aritems.amount-aritems.paid)',6,'',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'doc ref','aritems.relatedid','left','',2,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (303,'status','aritems.status','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'id','receipts.id','left','',0,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'client','if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)','left','',4,'',1,'100%',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'RTP','receipts.readytopost','center','',1,'',0,'','boolean',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'amount','receipts.amount','right','sum(receipts.amount)',6,'',0,'','currency',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'payment','paymentmethods.name','left','',5,'',0,'',NULL,0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'date','receipts.receiptdate','left','',3,'',0,'','date',0);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES (304,'status','receipts.status','left','',2,'',0,'',NULL,0);
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES ('303', 'if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)', '1', '1', '', '0');
INSERT INTO `tablegroupings` (`tabledefid`, `field`, `displayorder`, `ascending`, `name`, `roleid`) VALUES ('304', 'if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company)', '1', '1', '', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (303,'All Records','aritems.id!=-1',3,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (303,'open items','aritems.status = \'open\'',0,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (303,'closed items','aritems.status = \'closed\'',1,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (303,'non-posted','aritems.posted = 0',2,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (304,'ready to post','receipts.readytopost = 1',3,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (304,'non-posted, open','receipts.posted = 0 AND receipts.status = \'open\'',1,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (304,'non-posted, collected','receipts.posted = 0 AND receipts.status = \'collected\'',2,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (304,'All Records','receipts.id!=-1',5,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (304,'non-posted','receipts.posted = 0',0,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (304,'posted','receipts.posted = 1',4,0);
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (303,'aritems.id','id',4,'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (303,'aritems.relatedid','invoice id',2,'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (303,'aritems.amount','amount',3,'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (303,'(clients.lastname like \"{{value}}%\" or clients.firstname like \"{{value}}%\" or clients.company like \"{{value}}%\")','client',1,'whereclause');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (304,'receipts.id','id',2,'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (304,'(clients.lastname like \"{{value}}%\" or clients.firstname like \"{{value}}%\" or clients.company like \"{{value}}%\")','client',1,'whereclause');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (304,'paymentmethods.name','payment',3,'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (304,'receipts.amount','amount',4,'field');
DELETE FROM `relationships`;
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'sales managers', 'salesmanagerid', '2', '9', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('clientid', 'sales orders', 'id', '2', '3', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'clients', 'clientid', '3', '2', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'tax areas', 'taxareaid', '3', '6', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'sales orders', 'invoiceid', '5', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'products', 'productid', '5', '4', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'parent products', 'parentid', '8', '4', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'child products', 'childid', '8', '4', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('categoryid', 'products', 'id', '7', '4', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('productid', 'sales order line items', 'id', '4', '5', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('parentid', 'prerequisites', 'id', '4', '8', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('taxareaid', 'sales orders', 'id', '6', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('salesmanagerid', 'sales person for clients', 'id', '9', '2', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('createdby', 'created clients', 'id', '9', '2', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('modifiedby', 'modified clients', 'id', '9', '2', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('createdby', 'created sales orders', 'id', '9', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('modifiedby', 'modified invoices', 'id', '9', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('invoiceid', 'line items', 'id', '3', '5', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('discountid', 'sales orders', 'id', '25', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'discounts', 'discountid', '3', '25', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'clients', 'clientid', '303', '2', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('clientid', 'AR items', 'id', '2', '303', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'invoices', 'relatedid', '303', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('relatedid', 'AR items', 'id', '3', '303', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'clients', 'clientid', '304', '2', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('clientid', 'receipts', 'id', '2', '304', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'product categories', 'categoryid', '4', '7', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('shippingmethodid', 'sales orders', 'id', '300', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('paymentmethodid', 'sales orders', 'id', '301', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('paymentmethodid', 'receipts', 'id', '301', '304', 1, NOW(), 1, NOW(), '1');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('id', 'receipts', 'relatedid', '303', '304', 1, NOW(), 1, NOW(), '0');
INSERT INTO `relationships` (`tofield`, `name`, `fromfield`, `fromtableid`, `totableid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`, `inherint`) VALUES ('assignedtoid', 'assigned to sales orders', 'id', '9', '3', 1, NOW(), 1, NOW(), '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'massEmail', 'send mass e-mail', '1', '0', '100');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'delete_prospects', 'delete prospects', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'stamp_infosent', 'info packet sent', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'mark_asclient', 'convert to client', '1', '0', '50');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'email_invoice', 'e-mail client invoice PDF', '1', '20', '100');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'mark_asinvoice', 'post as invoice', '1', '30', '50');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'mark_ashipped', 'mark as shipped', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'mark_rtp', 'mark ready to post', '1', '20', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'email_quote', 'e-mail client quote PDF', '1', '20', '100');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'new', '1', '0', '20', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'mark_aspaid', 'pay in full', '1', '20', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('3', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('4', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('4', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('4', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('4', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('5', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('5', 'edit', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('5', 'new', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('5', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('6', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('6', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('6', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('6', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('7', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('7', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('7', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('7', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('8', 'new', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('8', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('8', 'edit', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('8', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'delete_prospects', 'delete prospects', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'edit', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'new', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('22', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('22', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('22', 'new', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('22', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('25', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('25', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('25', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('25', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('300', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('300', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('300', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('300', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('301', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('301', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('301', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('301', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('302', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('302', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('302', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('302', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('303', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('303', 'run_aging', 'run aging', '1', '80', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('303', 'new', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('303', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('303', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'mark_rtp', 'mark ready to post', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'post', 'post receipt', '1', '30', '100');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('304', 'mark_collected', 'mark as collected', '1', '0', '0');