CREATE TABLE `addresses` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `title` VARCHAR(128), `shiptoname` VARCHAR(128), `address1` VARCHAR(128), `address2` VARCHAR(128), `city` VARCHAR(64), `state` VARCHAR(20), `postalcode` VARCHAR(15), `country` VARCHAR(64), `phone` VARCHAR(25), `email` VARCHAR(128), `notes` TEXT, `createdby` INTEGER UNSIGNED NOT NULL, `creationdate` DATETIME NOT NULL, `modifiedby` INTEGER UNSIGNED, `modifieddate` TIMESTAMP, PRIMARY KEY(`id`));
CREATE TABLE `addresstorecord` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `tabledefid` INTEGER UNSIGNED NOT NULL, `recordid` INTEGER UNSIGNED NOT NULL, `addressid` INTEGER UNSIGNED NOT NULL, `defaultshipto` TINYINT UNSIGNED NOT NULL DEFAULT 0, `primary` TINYINT UNSIGNED NOT NULL DEFAULT 0, `createdby` INTEGER UNSIGNED NOT NULL, `creationdate` DATETIME NOT NULL, `modifiedby` INTEGER UNSIGNED, `modifieddate` TIMESTAMP, PRIMARY KEY(`id`));
ALTER TABLE `invoices` ADD COLUMN `shiptoname` VARCHAR(128), ADD COLUMN `shiptoaddress1` VARCHAR(128), ADD COLUMN `shiptoaddress2` VARCHAR(128),ADD COLUMN `shiptocity` VARCHAR(64), ADD COLUMN `shiptostate` VARCHAR(20), ADD COLUMN `shiptopostalcode` VARCHAR(15), ADD COLUMN `shiptocountry` VARCHAR(64), ADD COLUMN `billingaddressid` INTEGER, ADD COLUMN `shiptoaddressid` INTEGER, ADD COLUMN `shiptosameasbilling` TINYINT UNSIGNED NOT NULL DEFAULT 0;
INSERT INTO `settings` (`name`, `value`) VALUES ('clear_payment_on_invoice','1');
INSERT INTO `smartsearches` (`id`, `name`, `fromclause`, `valuefield`, `displayfield`, `secondaryfield`, `classfield`, `searchfields`, `filterclause`, `rolefield`, `tabledefid`, `moduleid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('1', 'Pick Exisiting Client Address', '(clients INNER JOIN addresstorecord ON clients.id = addresstorecord.recordid AND addresstorecord.tabledefid = 2) INNER JOIN addresses ON addresstorecord.addressid = addresses.id', 'addresses.id', 'concat(if(clients.lastname!=\"\",concat(clients.lastname,\", \",clients.firstname,if(clients.company!=\"\",concat(\" (\",clients.company,\")\"),\"\")),clients.company), if(addresses.title != \"\",concat(\" [\", addresses.title, \"]\"),\"\"))', 'CONCAT(addresses.address1,if(addresses.address2 != \'\',concat(\'[br]\', addresses.address2),\'\'),if(addresses.city != \'\',concat(\'[br]\',addresses.city,\', \',if(addresses.state != \'\',addresses.state, \'\'),\' \',if(addresses.postalcode != \'\', addresses.postalcode, \'\')),\'\'),if(addresses.country != \'\',concat(\'[br]\',addresses.country),\'\'))', 'if(addresstorecord.primary,\'primary\',\'\')', 'clients.firstname, clients.lastname, clients.company, addresses.title, addresses.address1', 'clients.inactive=0', NULL, '306', '2', 1, NOW(), 1, NOW());
INSERT INTO `smartsearches` (`id`, `name`, `fromclause`, `valuefield`, `displayfield`, `secondaryfield`, `classfield`, `searchfields`, `filterclause`, `rolefield`, `tabledefid`, `moduleid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('3', 'Pick Sales Order Client', '((clients INNER JOIN addresstorecord on clients.id = addresstorecord.recordid AND addresstorecord.tabledefid=2 AND addresstorecord.primary=1) INNER JOIN addresses ON  addresstorecord.addressid = addresses.id)', 'clients.id', 'IF(clients.company != \'\', CONCAT(clients.company,IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(\' (\',if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\'),\')\'), \'\')), IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\')), \'\'))', 'IF(addresses.city != \'\' OR addresses.state !=\'\' OR addresses.postalcode != \'\', CONCAT(IF(addresses.city != \'\',addresses.city,\'\'),\', \',IF(addresses.state != \'\', addresses.state, \'\'),\' \',IF(addresses.postalcode != \'\', addresses.postalcode, \'\')),\'unspecified location\')', 'clients.type', 'clients.company, clients.firstname, clients.lastname', 'clients.inactive=0', NULL, '2', '2', 1, NOW(), 1, NOW());
INSERT INTO `smartsearches` (`id`, `name`, `fromclause`, `valuefield`, `displayfield`, `secondaryfield`, `classfield`, `searchfields`, `filterclause`, `rolefield`, `tabledefid`, `moduleid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('4', 'Pick Product', 'products', 'products.id', 'CONCAT(products.partnumber,IF(products.partname != \'\',CONCAT(\' :: \',products.partname),\'\'))', 'products.type', '\'\'', 'products.partnumber, products.partname', 'products.inactive = 0 AND products.status = \'In Stock\'', NULL, '4', '2', 1, NOW(), 1, NOW());
INSERT INTO `smartsearches` (`id`, `name`, `fromclause`, `valuefield`, `displayfield`, `secondaryfield`, `classfield`, `searchfields`, `filterclause`, `rolefield`, `tabledefid`, `moduleid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('6', 'Pick Client With Credit', '((clients INNER JOIN addresstorecord on clients.id = addresstorecord.recordid AND addresstorecord.tabledefid=2 AND addresstorecord.primary=1) INNER JOIN addresses ON  addresstorecord.addressid = addresses.id)', 'clients.id', 'IF(clients.company != \'\', CONCAT(clients.company,IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(\' (\',if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\'),\')\'), \'\')), IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\')), \'\'))', 'IF(addresses.city != \'\' OR addresses.state !=\'\' OR addresses.postalcode != \'\', CONCAT(IF(addresses.city != \'\',addresses.city,\'\'),\', \',IF(addresses.state != \'\', addresses.state, \'\'),\' \',IF(addresses.postalcode != \'\', addresses.postalcode, \'\')),\'unspecified location\')', '\'\'', 'clients.company, clients.firstname, clients.lastname', 'clients.inactive = 0 AND clients.type=\'client\' AND clients.hascredit=1', NULL, '2', '2', 1, NOW(), 1, NOW());
INSERT INTO `smartsearches` (`id`, `name`, `fromclause`, `valuefield`, `displayfield`, `secondaryfield`, `classfield`, `searchfields`, `filterclause`, `rolefield`, `tabledefid`, `moduleid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('7', 'Pick Client By Email', 'clients', 'clients.id', 'IF(clients.company != \'\', CONCAT(clients.company,IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(\' (\',if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\'),\')\'), \'\')), IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\')), \'\'))', 'clients.email', 'clients.type', 'clients.email', 'clients.inactive = 0', NULL, '2', '2', 1, NOW(), 1, NOW());
INSERT INTO `smartsearches` (`id`, `name`, `fromclause`, `valuefield`, `displayfield`, `secondaryfield`, `classfield`, `searchfields`, `filterclause`, `rolefield`, `tabledefid`, `moduleid`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('8', 'Pick Client By Phone', 'clients', 'clients.id', 'IF(clients.company != \'\', CONCAT(clients.company,IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(\' (\',if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\'),\')\'), \'\')), IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\')), \'\'))', 'CONCAT(IF(clients.workphone != \'\',CONCAT(clients.workphone,\' (w)[br]\'),\'\'),IF(clients.homephone != \'\',CONCAT(clients.homephone,\' (h)[br]\'),\'\'),IF(clients.mobilephone != \'\',CONCAT(clients.mobilephone,\' (m)[br]\'),\'\'),IF(clients.otherphone != \'\',CONCAT(clients.otherphone,\' (o)[br]\'),\'\'),IF(clients.fax != \'\',CONCAT(clients.fax,\' (fax)\'),\'\'))', 'clients.type', 'clients.workphone, clients.homephone, clients.mobilephone, clients.otherphone, clients.fax', 'clients.inactive = 0', NULL, '2', '2', 1, NOW(), 1, NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('303', 'addresses', 'clients entry', 'modules/bms/clients_addresses.php', '12', '0', '0', NULL, NULL, 1, NOW(), 1, NOW());
DELETE FROM `tabledefs` WHERE id = 2 or id = 18;
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('2', 'Clients', 'table', '2', 'clients', '((clients INNER JOIN addresstorecord on clients.id = addresstorecord.recordid AND addresstorecord.tabledefid=2 AND addresstorecord.primary=1) INNER JOIN addresses ON  addresstorecord.addressid = addresses.id)', 'modules/bms/clients_addedit.php', '0', 'modules/bms/clients_addedit.php', '0', '0', '-100', '-100', 'inactivate', 'clients.id=-100', 'clients.company, clients.lastname, clients.firstname', NULL, NULL, NULL, 1, NOW(), 1, NOW());
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('18', 'Client Duplicates', 'view', '2', 'clients', '((clients INNER JOIN addresstorecord on clients.id = addresstorecord.recordid AND addresstorecord.tabledefid=2 AND addresstorecord.primary=1) INNER JOIN addresses ON addresstorecord.addressid = addresses.id),((clients AS dclients INNER JOIN addresstorecord as daddresstorecord on dclients.id = daddresstorecord.recordid AND daddresstorecord.tabledefid=2 AND daddresstorecord.primary=1) INNER JOIN addresses AS daddresses ON daddresstorecord.addressid = daddresses.id)', 'N/A', '0', 'N/A', '0', '0', '-100', '-100', 'NA', 'clients.id = -100', 'clients.company, clients.lastname, clients.firstname', NULL, NULL, NULL, 1, NOW(), 1, NOW());
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('305', 'Client Addresses', 'view', '2', 'addresstorecord', '((addresstorecord INNER JOIN addresses ON addresstorecord.addressid = addresses.id) INNER JOIN clients ON addresstorecord.recordid = clients.id)', 'modules/bms/addresses_addedit.php', '0', 'modules/bms/addresses_addedit.php', '0', '0', '-100', '-100', 'remove', 'addresstorecord.tabledefid=2 AND addresstorecord.id = -100', 'addresstorecord.primary DESC,  addresstorecord.defaultshipto DESC,  addresses.title,  addresses.address1', NULL, NULL, NULL, 1, NOW(), 1, NOW());
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES ('306', 'Addresses', 'table', '2', 'addresses', 'addresses', 'modules/bms/addresses_addedit.php', '0', 'modules/bms/addresses_addedit.php', '0', '0', '-100', '-100', 'delete', 'addresses.id != -100', 'address.title', NULL, NULL, NULL, 1, NOW(), 1, NOW());
DELETE FROM `tablecolumns` WHERE tabledefid = 2 OR tabledefid = 18;
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('2', 'e-mail', 'clients.email', 'left', '', '3', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('2', 'has credit', 'clients.hascredit', 'center', '', '1', '', '0', '', 'boolean', '80');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('2', 'name / location', 'CONCAT(\'[b]\',IF(clients.company != \'\', CONCAT(clients.company,IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(\' (\',if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\'),\')\'), \'\')), IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\')), \'\')),\'[/b][br][space]\', IF(addresses.city != \'\' OR addresses.state !=\'\' OR addresses.postalcode != \'\', CONCAT(IF(addresses.city != \'\',addresses.city,\'\'),\', \',IF(addresses.state != \'\', addresses.state, \'\'),\' \',IF(addresses.postalcode != \'\', addresses.postalcode, \'\')),\'(no location)\'))', 'left', '', '2', 'concat(clients.company,clients.lastname,clients.firstname)', '0', '100%', 'bbcode', '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('2', 'type', 'clients.type', 'left', '', '0', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('2', 'phone', 'IF(clients.workphone != \'\' OR clients.homephone != \'\' OR clients.mobilephone != \'\' OR clients.otherphone != \'\',IF(clients.workphone != \'\', concat(clients.workphone, \' (w)\'), IF(clients.homephone != \'\', concat(clients.homephone, \' (h)\'), IF(clients.mobilephone != \'\', concat(clients.mobilephone, \' (m)\'), IF(clients.otherphone != \'\', concat(clients.otherphone, \' (o)\'), \'\')))) ,\'\')', 'left', '', '4', 'concat(clients.workphone, clients.homephone, clients.mobilephone,clients.otherphone)', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('18', 'id', 'clients.id', 'center', '', '0', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('18', 'type', 'clients.type', 'left', '', '1', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('18', 'name', 'IF(clients.company != \'\', CONCAT(clients.company,IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(\' (\',if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\'),\')\'), \'\')), IF(clients.lastname != \'\' OR clients.firstname != \'\', CONCAT(if(clients.lastname != \'\', clients.lastname, \'{blank}\'),\', \',if(clients.firstname != \'\', clients.firstname, \'{blank}\')), \'\'))', 'left', '', '2', 'concat(clients.company,clients.lastname,clients.firstname)', '1', '100%', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('305', 'address', 'concat(if(addresses.title != \'\',concat(\'[b]\',addresses.title,\'[/b][br]\'),\'\'),IF(addresses.address1!=\'\',addresses.address1,\'\'),if(addresses.address2 != \'\',concat(\'[br]\', addresses.address2),\'\'),if(addresses.city != \'\',concat(\'[br]\',addresses.city,\', \',if(addresses.state != \'\',addresses.state, \'\'),\' \',if(addresses.postalcode != \'\', addresses.postalcode, \'\')),\'\'),if(addresses.country != \'\',concat(\'[br]\',addresses.country),\'\'))', 'left', '', '0', '', '1', '100%', 'bbcode', '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('305', 'default ship to', 'addresstorecord.defaultshipto', 'center', '', '4', '', '0', '', 'boolean', '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('305', 'ship to name', 'addresses.shiptoname', 'left', '', '3', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('305', 'phone', 'addresses.phone', 'left', '', '2', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('305', 'email', 'addresses.email', 'left', '', '1', '', '0', '', NULL, '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('305', 'primary', 'addresstorecord.primary', 'center', '', '5', '', '0', '', 'boolean', '0');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`, `roleid`) VALUES ('306', 'id', 'addresses.id', 'left', '', '0', '', '0', '', NULL, '0');
DELETE FROM `tablefindoptions` WHERE tabledefid = 2 OR tabledefid = 18;
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'Prospects', 'clients.type = \"prospect\"   and clients.inactive=0', '1', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'Today\'s Prospects', 'clients.type = \"prospect\" and (TO_DAYS(now())-TO_DAYS(clients.creationdate))=0 and clients.inactive=0', '3', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'Yesterday\'s Prospects', 'clients.type = \"prospect\" and (TO_DAYS(now())-TO_DAYS(clients.creationdate))=1 and clients.inactive=0', '4', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'Last Week\'s Prospects', 'clients.type = \"prospect\" and (TO_DAYS(now())-TO_DAYS(clients.creationdate))<7 and clients.inactive=0', '5', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'Clients', 'clients.type = \"client\" and clients.inactive=0', '0', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'Inactive Clients', 'clients.type = \"client\" and clients.inactive=1', '6', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('2', 'All Records', 'clients.id != 0', '7', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('18', 'match names', 'clients.firstname=dclients.firstname AND clients.lastname=dclients.lastname AND clients.lastname != \'\' AND clients.firstname != \'\' AND  clients.id<>dclients.id', '1', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('18', 'match names and postal code', 'clients.firstname=dclients.firstname AND clients.lastname=dclients.lastname AND addresses.postalcode = daddresses.postalcode AND clients.lastname != \'\' AND clients.firstname != \'\' AND addresses.postalcode != \'\' AND clients.id<>dlients.ID', '2', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('18', 'match addresses', 'addresses.address1=addresses..address1 AND clients.id<>dclients.id', '3', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('305', 'All Records', 'addresstorecord.id!=-1', '0', '0');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES ('306', 'All Records', 'addresses.id!=-1', '0', '0');
DELETE FROM `tableoptions` WHERE tabledefid = 2 OR tabledefid = 18;
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'massEmail', 'send mass e-mail', '1', '0', '100');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'mark_asclient', 'convert to client', '1', '0', '50');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'stamp_infosent', 'info packet sent', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'delete_prospects', 'delete prospects', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('2', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'new', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'edit', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('18', 'delete_prospects', 'delete prospects', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('305', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('305', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('305', 'printex', '0', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('305', 'select', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('305', 'markDefaultShipTo', 'mark default ship to', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('305', 'markPrimary', 'mark primary address', '1', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('306', 'new', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('306', 'edit', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('306', 'printex', '1', '0', '0', '0');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`, `displayorder`) VALUES ('306', 'select', '1', '0', '0', '0');
DELETE FROM `tablesearchablefields` WHERE tabledefid = 2 OR tabledefid = 18;
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', '(clients.lastname like \"{{value}}%\" or clients.firstname like \"{{value}}%\" or clients.company like \"{{value}}%\")', ' name', '0', 'whereclause');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', 'clients.id', 'id', '7', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', 'clients.leadsource', 'lead source', '6', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', 'clients.email', 'e-mail', '5', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', 'addresses.postalcode', 'postal code', '4', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', 'addresses.state', 'state/province', '3', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', 'addresses.city', 'city', '2', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('2', '(clients.homephone like \"{{value}}%\" or clients.workphone like \"{{value}}%\" or clients.mobilephone like \"{{value}}%\" or clients.otherphone like \"{{value}}%\" or clients.fax like \"{{value}}%\")', 'phone', '1', 'whereclause');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('18', '(clients.lastname like \"{{value}}%\" or clients.firstname like \"{{value}}%\" or clients.company like \"{{value}}%\")', 'name', '0', 'whereclause');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('18', '(clients.homephone like \"{{value}}%\" or clients.workphone like \"{{value}}%\" or clients.mobilephone like \"{{value}}%\" or clients.otherphone like \"{{value}}%\" or clients.fax like \"{{value}}%\")', 'phone', '1', 'whereclause');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('18', 'clients.email', 'e-mail', '5', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('18', 'clients.id', 'id', '6', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('305', 'addresstorecord.id', 'id', '1', 'field');
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES ('306', 'addresses.id', 'id', '1', 'field');
