<!DOCTYPE html>
<html lang="<?php echo empty($lang) ? 'cs' : $lang; ?>" dir="ltr">
<head>
<meta charset="utf-8">
<meta name="robots" content="<?php echo $robots; ?>">
<meta name="author" content="Kanaly.eu">
<meta name="copyright" content="Kanaly.eu">
<meta name="description" content="Kanaly.eu">
<meta name="page-topic" content="Kanaly.eu">
<meta name="abstract" content="Kanaly.eu">
<meta name="keywords" content="Kanaly.eu">

<title><?php echo $title; ?> | Kanaly.eu </title>

<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="css/common.css" type="text/css" media="screen">

<script src="js/jquery.js"></script>
<script src="https://maps.googleapis.com/maps/api/js"></script>
<script src="js/js.js"></script>

<script>
(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r; i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date(); a=s.createElement(o), m=s.getElementsByTagName(o)[0]; a.async=1; a.src=g; m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','ga'); ga('create', 'UA-54651325-5', 'auto'); ga('send', 'pageview');
</script>

</head>

<body class="fs12 osr">

<header>
	<div id="container">
		<nav>
			<a href="index.php<?php echo $lang; ?>" title="<?php echo $local['logo_title']; ?>">
				<div id="logo" class="l"></div>
			</a>

			<div id="langs" class="r">
				<ul>
					<li class="r flag last_flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?lang=pl"><img src="img/pl.png" alt="<?php echo $local['vlajka_pl']; ?>" title="Polski"></a></li>
					<li class="r flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?lang=tr"><img src="img/tr.png" alt="<?php echo $local['vlajka_tr']; ?>" title="Türk"></a></li>
					<!-- <li class="r flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?lang=fr"><img src="img/fr.png" alt="<?php echo $local['vlajka_fr']; ?>" title="Français"></a></li> -->
					<li class="r flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?lang=it"><img src="img/it.png" alt="<?php echo $local['vlajka_it']; ?>" title="Italiano"></a></li>
					<li class="r flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?lang=en"><img src="img/en.png" alt="<?php echo $local['vlajka_en']; ?>" title="English"></a></li>
					<li class="r flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?lang=de"><img src="img/de.png" alt="<?php echo $local['vlajka_de']; ?>" title="Deutsch"></a></li>
					<li class="r flag"><a href="<?php echo $_SERVER['SCRIPT_NAME']; ?>"><img src="img/cz.png" alt="<?php echo $local['vlajka_cz']; ?>" title="Česky"></a></li>
				</ul>
			</div>

			<menu class="r">
				<ul>
					<li><a class="r ossb gray upper menu_item last_menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/kontakt.php' ? 'active' : ''; ?>" href="kontakt.php<?php echo $lang; ?>"><?php echo $local['menu_kontakt']; ?></a></li>
					<li><a class="r ossb gray upper menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/partneri.php' ? 'active' : ''; ?>" href="partneri.php<?php echo $lang; ?>"><?php echo $local['menu_partneri']; ?></a></li>
					<li><a class="r ossb gray upper menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/postup.php' ? 'active' : ''; ?>" href="postup.php<?php echo $lang; ?>"><?php echo $local['menu_postup']; ?></a></li>
					<li><a class="r ossb gray upper menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/certifikaty.php' ? 'active' : ''; ?>" href="certifikaty.php<?php echo $lang; ?>"><?php echo $local['menu_certifikaty']; ?></a></li>
					<li><a class="r ossb gray upper menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/mapa.php' ? 'active' : ''; ?>" href="mapa.php<?php echo $lang; ?>"><?php echo $local['menu_mapa']; ?></a></li>
					<li><a class="r ossb gray upper menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/katalog.php' ? 'active' : ''; ?>" href="katalog.php<?php echo $lang; ?>"><?php echo $local['menu_katalog']; ?></a></li>
					<li><a class="r ossb gray upper menu_item <?php echo $_SERVER['SCRIPT_NAME'] == '/index.php' ? 'active' : ''; ?>" href="index.php<?php echo $lang; ?>"><?php echo $local['menu_uvod']; ?></a></li>
				</ul>
			</menu>
		</nav>
	</div>
</header>