<?php

/*
 Helper functions for the ISPConfig Billing module
 (c) Till Brehm, ISPConfig UG 2011
*/

class billing_functions {
	
	/*
	   Function returns the global invoice settings array
	*/
	function get_invoice_settings() {
		global $app;
		return $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
	}
	
	
	/* 
	   Function to get the path and filename of a invoice. 
	   The parameter is the invoice number (not invoice_id).
	*/
	function get_invoice_filename($invoice_number) {
		global $app, $conf;
		
		//* Get the invoice settings
		$invoice_settings = $this->get_invoice_settings();
		
		//* Replace unknown chars with underscore in invoice number
		$invoice_number = preg_replace('/[^\w\d_ -]/si', '_', $invoice_number);
		
		//* Make the invoice filename
		if($invoice_settings['invoice_dir'] != ''&& $conf['demo_mode'] == false) {
			if(!is_dir($invoice_settings['invoice_dir']) || !is_writable($invoice_settings['invoice_dir'])) die('Invoice directory does not exist or is not writable by server process: '.$invoice_settings['invoice_dir']);
			$invoice_filename = $invoice_settings['invoice_dir'].'/'.$invoice_number.'.pdf';
		} else {
			$invoice_filename = ISPC_ROOT_PATH.'/invoices/'.$invoice_number.'.pdf';
		}
		return $invoice_filename;
	}
	
	
}

?>