<?php

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');

//* Check permissions for module
$app->auth->check_module_permissions('billing');

$app->uses('tpl,billing_functions');

$app->tpl->newTemplate('form.tpl.htm');
$app->tpl->setInclude('content_tpl', 'templates/billing_dashboard.htm');

$invoice_settings = $app->billing_functions->get_invoice_settings();

//* Calculate this months income
$this_month_first_day = date('Y-m-d',mktime(0, 0, 0, date("m"), 1,   date("Y")));
$this_month_last_day = date('Y-m-d',mktime(0, 0, 0, date("m")+1, 0,   date("Y")));

$rec = $app->db->queryOneRecord("SELECT sum(invoice_amount) as income FROM invoice WHERE (invoice_type = 'invoice' or invoice_type = 'refund') AND status_printed = 'y' AND invoice_date BETWEEN '$this_month_first_day' AND '$this_month_last_day'");
$income_this_month = $app->functions->currency_format($rec['income']).' '.$invoice_settings['currency'];
$app->tpl->setVar('income_this_month',$income_this_month);

//* Calculate last months income
$last_month_first_day = date('Y-m-d',mktime(0, 0, 0, date("m")-1, 1,   date("Y")));
$last_month_last_day = date('Y-m-d',mktime(0, 0, 0, date("m"), 0,   date("Y")));

$rec = $app->db->queryOneRecord("SELECT sum(invoice_amount) as income FROM invoice WHERE (invoice_type = 'invoice' or invoice_type = 'refund') AND status_printed = 'y' AND invoice_date BETWEEN '$last_month_first_day' AND '$last_month_last_day'");
$income_last_month = $app->functions->currency_format($rec['income']).' '.$invoice_settings['currency'];
$app->tpl->setVar('income_last_month',$income_last_month);

//* Calculate this years income
$this_year_first_day = date('Y-m-d',mktime(0, 0, 0, 1, 1,   date("Y")));
$this_year_last_day = date('Y-m-d',mktime(0, 0, 0, 12, 31,   date("Y")));

$rec = $app->db->queryOneRecord("SELECT sum(invoice_amount) as income FROM invoice WHERE (invoice_type = 'invoice' or invoice_type = 'refund') AND status_printed = 'y' AND invoice_date BETWEEN '$this_year_first_day' AND '$this_year_last_day'");
$income_this_year = $app->functions->currency_format($rec['income']).' '.$invoice_settings['currency'];
$app->tpl->setVar('income_this_year',$income_this_year);

//* Calculate last years income
$last_year_first_day = date('Y-m-d',mktime(0, 0, 0, 1, 1,   date("Y")-1));
$last_year_last_day = date('Y-m-d',mktime(0, 0, 0, 12, 31,   date("Y")-1));

$rec = $app->db->queryOneRecord("SELECT sum(invoice_amount) as income FROM invoice WHERE (invoice_type = 'invoice' or invoice_type = 'refund') AND status_printed = 'y' AND invoice_date BETWEEN '$last_year_first_day' AND '$last_year_last_day'");
$income_last_year = $app->functions->currency_format($rec['income']).' '.$invoice_settings['currency'];
$app->tpl->setVar('income_last_year',$income_last_year);

//* Get details for chart
for ($m = 1; $m <= 12; $m++) {
	$month_first_day = date('Y-m-d',mktime(0, 0, 0, date("m")+ $m, 1,   date("Y")-1));
	$month_last_day = date('Y-m-d',mktime(0, 0, 0, date("m")+1+$m, 0,   date("Y")-1));
	
	$rec = $app->db->queryOneRecord("SELECT sum(invoice_amount) as income FROM invoice WHERE (invoice_type = 'invoice' or invoice_type = 'refund') AND status_printed = 'y' AND invoice_date BETWEEN '$month_first_day' AND '$month_last_day'");
	$income_array[] = $rec['income'];
	$tick_array[] = date('m',mktime(0, 0, 0, date("m")+ $m, 1,   date("Y")-1)).'/'.date('Y',mktime(0, 0, 0, date("m")+ $m, 1,   date("Y")-1));
	
	$income = implode(',',$income_array);
	$ticks = implode("','",$tick_array);
}

$app->tpl->setVar('ticks',$ticks);
$app->tpl->setVar('income',$income);
$app->tpl->setVar('currency_txt',$invoice_settings['currency']);


//* Get latest invoices
$sql = "SELECT * FROM invoice WHERE status_printed = 'y' ORDER BY invoice_date DESC LIMIT 0,5";
$records = $app->db->queryAllRecords($sql);
$records_new = array();
$has_invoice_records = 0; 
if(is_array($records)) {
	foreach($records as $rec) {
		$rec['invoice_amount'] = $app->functions->currency_format($rec['invoice_amount']);
		$tmp = explode('-',$rec['invoice_date']);
		$rec['invoice_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1]  , $tmp[2], $tmp[0]));
		$records_new[] = $rec;
	}
	$has_invoice_records = 1;
}
$app->tpl->setVar('has_invoice_records',$has_invoice_records);
$app->tpl->setLoop('invoice_records',$records_new);

//* Get overdue invoices
//* Get all payment terms
$payment_terms = array();
$tmp_payment_terms = $app->db->queryAllRecords("SELECT invoice_payment_term_id AS id,due_days FROM invoice_payment_term");
foreach($tmp_payment_terms as $tmp) {
	$key = $tmp['id'];
	$payment_terms[$key] = $tmp['due_days'];
}
unset($tmp_payment_terms);
unset($tmp);
unset($key);
	
//* Select all unpaid invoices
$sql = "SELECT * FROM client, invoice WHERE client.client_id = invoice.client_id AND invoice.status_printed = 'y' AND invoice.status_paid = 'n'";
$invoices = $app->db->queryAllRecords($sql);
$now_tstamp = time();
$invoices_due = array();
$n = 0;
$has_invoice_due = 0;
if(is_array($invoices)) {

	foreach($invoices as $invoice) {
		//* Check if onvoice is overdue
		$invoice_date_parts = explode('-',$invoice['invoice_date']);
		$payment_terms_id = $invoice['payment_terms'];
		$due_date_tstamp = mktime(0, 0, 0, $invoice_date_parts[1]  , (int)$invoice_date_parts[2]+$payment_terms[$payment_terms_id], (int)$invoice_date_parts[0]);
		if($due_date_tstamp < $now_tstamp && $n < 5) {
			$tmp = explode('-',$invoice['invoice_date']);
			$invoices_due[] = array(		'invoice_date' => date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1]  , $tmp[2], $tmp[0])),
											'due_date' => date('Y-m-d',$due_date_tstamp),
											'invoice_number' => $invoice['invoice_number'],
											'invoice_id' => $invoice['invoice_id'],
											'contact_name' => $invoice['contact_name'],
											'company_name' => $invoice['company_name'],
											'invoice_amount' => $app->functions->currency_format($invoice['invoice_amount'])
										);
		$n++;
		$has_invoice_due = 1;
		}
	}
}
$app->tpl->setVar('has_invoice_due',$has_invoice_due);
$app->tpl->setLoop('invoice_due',$invoices_due);


$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_billing_dashboard.lng';
include($lng_file);
$app->tpl->setVar($wb);

$app->tpl_defaults();
$app->tpl->pparse();

?>
  
  
  
  