<?php
/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');

/******************************************
* Begin Form configuration
******************************************/

$list_def_file = "list/invoice.list.php";

/******************************************
* End Form configuration
******************************************/

//* Check permissions for module
$app->auth->check_module_permissions('billing');

// Loading classes
$app->load('listform_actions');

class listform_action extends listform_actions {
	public function onShow() {
		global $app;
		
			$app->uses('billing_functions');
			$invoice_settings = $app->billing_functions->get_invoice_settings();
			
			$app->tpl->setVar('currency_txt',$invoice_settings['currency']);
		
		parent::onShow();
	}
}

$list = new listform_action;
$list->SQLOrderBy = 'ORDER BY invoice_number DESC';
$list->SQLExtWhere = "invoice_type = 'invoice' AND status_printed = 'n'";
$list->onLoad();


?>