<?php

/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/

class plugin_invoiceitem extends plugin_base {

	var $module;
	var $form;
	var $tab;
	var $record_id;
	var $formdef;
	var $options;
	var $error = '';

	function onShow() {
		global $app,$conf;
			
		$pluginTpl = new tpl;
		$pluginTpl->newTemplate('templates/invoice_edit_item_input.htm');
		
		if($_GET['action'] == 'del' && $_GET['invoice_item_id'] > 0) {
			$invoice_item_id = intval($_GET['invoice_item_id']);
			$app->db->query("DELETE FROM invoice_item WHERE invoice_item_id = $invoice_item_id");
		}
		
		if($_GET['action'] == 'edit' && $_GET['invoice_item_id'] > 0) {
			// Edit a existing invoice item
			$invoice_item_id = intval($_GET['invoice_item_id']);
			$rec = $app->db->queryOneRecord("SELECT * FROM invoice_item WHERE invoice_item_id = $invoice_item_id");
			$rec['price'] = $app->functions->currency_format($rec['price']);
			$rec['vat'] = $app->functions->currency_format($rec['vat']);
			$pluginTpl->setVar($rec);
		} elseif ($_GET['action'] == 'load' && $_GET['invoice_item_template_id'] > 0) {
			// Load invoice item settings from template
			$invoice_item_template_id = intval($_GET['invoice_item_template_id']);
			$rec = $app->db->queryOneRecord("SELECT * FROM invoice_item_template WHERE invoice_item_template_id = $invoice_item_template_id");
			$rec['quantity'] = 1;
			$pluginTpl->setVar($rec);
		} else {
			// Set the defaults
			$rec = array();
			$rec['quantity'] = 1;
			$rec['price'] = $app->functions->currency_format(0);
			$rec['vat'] = $app->functions->currency_format(19);
			$pluginTpl->setVar($rec);
		}
		
		include('lib/lang/'.$_SESSION['s']['language'].'_invoice.lng');
		$pluginTpl->setVar($wb);
		
		// Fill the invoice_item_template_id select
		$tmp_out = '<option>-- '.$wb['item_txt'].' --</option>';
		$tmp_recs = $app->db->queryAllRecords("SELECT invoice_item_template_id,name FROM invoice_item_template WHERE type != 'Recurring'");
		if(is_array($tmp_recs)) {
			foreach($tmp_recs as $tmp) {
				$tmp_out .= '<option value="'.$tmp['invoice_item_template_id'].'">'.htmlentities($app->db->unquote($tmp['name'])).'</option>';
			}
		}
		$pluginTpl->setVar('invoice_item_template_id',$tmp_out);
		
		
               
		return $pluginTpl->grab();

	}
		
	function onUpdate() {
		global $app;
		
		if($_GET['action'] == 'save') {
			$invoice_item_template_id = intval($_POST['invoice_item_template_id']);
			$quantity = intval($_POST['quantity']);
			$price = floatval(str_replace(',','.',$_POST['price']));
			$vat = floatval(str_replace(',','.',$_POST['vat']));
			$invoice_item_id = intval($_POST['invoice_item_id']);
			$description = $app->db->quote($_POST['description']);
			$invoice_id = $this->form->id;
			
			if($invoice_item_id > 0) {
				$sql = "UPDATE invoice_item SET invoice_item_template_id = $invoice_item_template_id, quantity = $quantity, price = '$price', vat = $vat, description = '$description' WHERE invoice_item_id = $invoice_item_id";
			} else {
				$sql = "INSERT INTO invoice_item (invoice_id,invoice_item_template_id,quantity,price,vat,description) VALUES ($invoice_id,$invoice_item_template_id,$quantity,'$price',$vat,'$description')";
			}
			$app->db->query($sql);
		}
		
		
	}
}

?>