<?php

/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/

/*
	Datatypes:
	- INTEGER
	- DOUBLE
	- CURRENCY
	- VARCHAR
	- TEXT
	- DATE
*/



// Name of the list
$liste["name"] 				= "invoice_message";

// Database table
$liste["table"] 			= "invoice_message";

// Index index field of the database table
$liste["table_idx"]			= "invoice_message_id";

// Search Field Prefix
$liste["search_prefix"] 	= "search_";

// Records per page
$liste["records_per_page"] 	= 15;

// Script File of the list
$liste["file"]				= "invoice_message_list.php";

// Script file of the edit form
$liste["edit_file"]			= "invoice_message_edit.php";

// Script File of the delete script
$liste["delete_file"]		= "invoice_message_del.php";

// Paging Template
$liste["paging_tpl"]		= "templates/paging.tpl.htm";

// Enable authe
$liste["auth"]				= "yes";


/*****************************************************
* Suchfelder
*****************************************************/

$liste["item"][] = array(	'field'		=> "message_sent_date",
							'datatype'	=> "DATE",
							'formtype'	=> "TEXT",
							'op'		=> "like",
							'prefix'	=> "%",
							'suffix'	=> "%",
							'width'		=> "",
							'value'		=> "");

$liste["item"][] = array(	'field'		=> "client_id",
							'datatype'	=> "INTEGER",
							'formtype'	=> "SELECT",
							'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT client_id,CONCAT(company_name,' :: ',contact_name) as name FROM client ORDER BY company_name,contact_name",
										'keyfield'=> 'client_id',
										'valuefield'=> 'name'
									 ),
							'op'		=> "=",
							'prefix'	=> "",
							'suffix'	=> "",
							'width'		=> "",
							'value'		=> "");

$liste["item"][] = array(	'field'		=> "subject",
							'datatype'	=> "VARCHAR",
							'formtype'	=> "TEXT",
							'op'		=> "like",
							'prefix'	=> "%",
							'suffix'	=> "%",
							'width'		=> "",
							'value'		=> "");





?>