<?php

class dashlet_invoices {
	
	function show() {
		global $app, $conf;
		
		//* Loading Template
		$app->uses('tpl');
		
		$tpl = new tpl;
		$tpl->newTemplate("dashlets/templates/invoices.htm");
		
		$wb = array();
		$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_dashlet_invoices.lng';
		if(is_file($lng_file)) include($lng_file);
		$tpl->setVar($wb);
		
		$group_rec = $app->db->queryOneRecord('SELECT client_id FROM sys_group WHERE groupid = '.$_SESSION['s']['user']['default_group']);
		$client_id = $group_rec['client_id'];
		$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
		$has_invoices = false;
		
		if($client_id > 0) {
			$tmps = $app->db->queryAllRecords("SELECT * FROM invoice WHERE status_printed = 'y' AND client_id = $client_id ORDER BY invoice_date DESC, invoice_number DESC LIMIT 0,12");
			$invoices = array();
			if(is_array($tmps)) {
				foreach($tmps as $tmp) {
					
					$tmp['invoice_amount'] = $app->functions->currency_format($tmp['invoice_amount']);
					
					$date_parts = explode('-',$tmp['invoice_date']);
					$tmp['invoice_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $date_parts[1]  , $date_parts[2], $date_parts[0]));
					$tmp['currency'] = $invoice_settings['currency'];
					
					if($tmp['status_paid'] == 'y') {
						$tmp['invoice_status'] = '<span style="color:#00cc00;">'.$wb['paid_txt'].'</span>';;
					} else {
						if($tmp['invoice_type'] == 'invoice') {
							if(isset($invoice_settings['invoice_pay_link']) && $invoice_settings['invoice_pay_link'] != '') {
								$invoice_pay_link = $invoice_settings['invoice_pay_link'].$tmp['idhash'];
							} else {
								$invoice_pay_link = 'http://'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'].'/billing/payments/pay.php?id='.$tmp['idhash'];
							}
							$tmp['invoice_status'] = '<span style="color:#cc0000;">'.$wb['unpaid_txt'].'</span><br />[<a href="'.$invoice_pay_link.'" target="_blank">'.$wb['paynow_txt'].'</a>]';
						} else {
							$tmp['invoice_status'] = '<span style="color:#cc0000;">'.$wb['unpaid_txt'].'</span>';
						}
					}
					$invoices[] = $tmp;
				}
			}
			
			$tpl->setloop('invoices', $invoices);
			
			if(count($invoices) > 0) $has_invoices = true;
		}
		
		$tpl->setVar('has_invoices',$has_invoices);
		
		if($app->auth->is_admin()) {
			return '';
		} else {
			return $tpl->grab();
		}
		
		
	}
}








?>