<?php

/*
 Helper functions for the ISPConfig Billing module
 (c) Till Brehm, ISPConfig UG 2011
*/

class billing_functions {
	
	/*
	   Function returns the global invoice settings array
	*/
	function get_invoice_settings() {
		global $app;
		return $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
	}
	
	
	/* 
	   Function to get the path and filename of a invoice. 
	   The parameter is the invoice number (not invoice_id).
	*/
	function get_invoice_filename($invoice_number, $reminder_step = 0) {
		global $app, $conf;
		
		//* Get the invoice settings
		$invoice_settings = $this->get_invoice_settings();
		
		//* Replace unknown chars with underscore in invoice number
		$invoice_number = preg_replace('/[^\w\d_ -]/si', '_', $invoice_number);
        if($reminder_step > 0) $invoice_number .= '_r' . $reminder_step;
		
		//* Make the invoice filename
		if($invoice_settings['invoice_dir'] != ''&& $conf['demo_mode'] == false) {
			if(!is_dir($invoice_settings['invoice_dir']) || !is_writable($invoice_settings['invoice_dir'])) die('Invoice directory does not exist or is not writable by server process: '.$invoice_settings['invoice_dir']);
			$invoice_filename = $invoice_settings['invoice_dir'].'/'.$invoice_number.'.pdf';
		} else {
			$invoice_filename = ISPC_ROOT_PATH.'/invoices/'.$invoice_number.'.pdf';
		}
		return $invoice_filename;
	}
	
	/*
		This function assigns the invoice number
	*/
	function assign_invoice_number($invoice, $company){
		global $app;
		// Assign an invoice number
		if($invoice['invoice_number'] == '') {
			if($invoice['invoice_type'] == 'refund') {
				$type = 'refund';
			} elseif($invoice['invoice_type'] == 'proforma') {
				$type = 'proforma';
			} else {
				$type = 'invoice';
			}
			
			$current_time = time();
			
			if(strpos($company[$type.'_number_prefix'], '{COUNTER}') !== false){ // we use placeholders
				if(strpos($company[$type.'_number_prefix'], '{CLIENTNO}') !== false){ // pattern uses clientno, so we must fetch the last id from the invoice_client_settings table
					$client = $app->db->queryOneRecord("SELECT client.customer_no, invoice_client_settings.last_".$type."_number FROM invoice_client_settings, client WHERE invoice_client_settings.client_id = client.client_id AND client.client_id = ".$invoice['client_id']);
					$last_number = $client['last_'.$type.'_number'];
					$new_number = $last_number + 1;

					$trans = array('{COUNTER}' => str_pad($new_number, 4, "0", STR_PAD_LEFT), '{COMPANY_SHORT}' => $company['company_name_short'], '{YEAR}' => date('Y', $current_time), '{MONTH}' => date('m', $current_time), '{CLIENTNO}' => $client['customer_no']);
					$invoice_number = strtr($company[$type.'_number_prefix'], $trans);

					$app->db->query("UPDATE invoice_client_settings SET last_".$type."_number = $new_number WHERE client_id = ".$invoice['client_id']);
				} else { // pattern does not use clientno, therefore we use the last id from the invoice_company table
					$last_number = $company['last_'.$type.'_number'];
					$new_number = $last_number + 1;

					$trans = array('{COUNTER}' => str_pad($new_number, 4, "0", STR_PAD_LEFT), '{COMPANY_SHORT}' => $company['company_name_short'], '{YEAR}' => date('Y', $current_time), '{MONTH}' => date('m', $current_time));
					$invoice_number = strtr($company[$type.'_number_prefix'], $trans);

					$app->db->query("UPDATE invoice_company SET last_".$type."_number = $new_number WHERE invoice_company_id = ".$invoice['invoice_company_id']);
				}
			} else { // we don't use placeholders, therefore we append the invoice number to the prefix (instead of replacing the {COUNTER} placeholder)
				$last_number = $company['last_'.$type.'_number'];
				$prefix = $company[$type.'_number_prefix'];
				$new_number = $last_number + 1;
				$invoice_number = $prefix.str_pad($new_number, 4, "0", STR_PAD_LEFT);
				$app->db->query("UPDATE invoice_company SET last_".$type."_number = $new_number WHERE invoice_company_id = ".$invoice['invoice_company_id']);
			}
			
			$app->db->query("UPDATE invoice SET invoice_number = '$invoice_number' WHERE invoice_id = ".$invoice['invoice_id']);
			return $invoice_number;
		} else {
			return $invoice['invoice_number'];
		}
	}
	
	
}

?>