<?php

//* This class contains the remote functions for the ISPConfig billing addon

class billing_remote extends remoting {
	
	//* Get Invoice details by invoice_id or invoice_number or invoice_hash
	public function billing_invoice_get($session_id, $id) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		$id = $app->db->quote($id);
		return $app->db->queryOneRecord("SELECT * FROM invoice WHERE invoice_id = '$id' OR idhash = '$id' OR invoice_number = '$id' LIMIT 0,1");
	}
	
	//* Get Invoice details for all invoices of a client
	public function billing_invoice_get_by_client($session_id, $client_id, $number = 0) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$client_id = intval($client_id);
		$number = intval($number);
		
		if($number > 0) {
			$limit_sql = "LIMIT 0,$number";
		} else {
			$limit_sql = '';
		}
		
		return $app->db->queryAllRecords("SELECT * FROM invoice WHERE client_id = $client_id ORDER BY invoice_date $limit_sql");
	}
	
	//* Add a Invoice
	public function billing_invoice_add($session_id, $client_id, $override_params) {
	
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		//* Get the client and client_settings
		$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = $client_id");
		$client_settings = $app->db->queryOneRecord("SELECT * FROM invoice_client_settings WHERE client_id = $client_id");
		//$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
		//* Set the parameters in the $params array
		$params = array();
		$params['invoice_type'] = 'invoice';
		$params['invoice_company_id'] = (isset($override_params['invoice_company_id']))?$override_params['invoice_company_id']:$client_settings['invoice_company_id'];
		$params['client_id'] = $client_id;
		$params['invoice_number'] = '';
		$params['invoice_date'] = date($app->remoting_lib->dateformat);
		$params['payment_date'] = '0000-00-00';
		$params['company_name'] = (isset($override_params['company_name']))?$override_params['company_name']:$client['company_name'];
		$params['contact_name'] = (isset($override_params['contact_name']))?$override_params['contact_name']:$client['contact_name'];
		$params['street'] = (isset($override_params['street']))?$override_params['street']:$client['street'];
		$params['zip'] = (isset($override_params['zip']))?$override_params['zip']:$client['zip'];
		$params['city'] = (isset($override_params['city']))?$override_params['city']:$client['city'];
		$params['state'] = (isset($override_params['state']))?$override_params['state']:$client['state'];
		$params['country'] = (isset($override_params['country']))?$override_params['country']:$client['country'];
		$params['email'] = (isset($override_params['email']))?$override_params['email']:$client['email'];
		$params['vat_id'] = (isset($override_params['vat_id']))?$override_params['vat_id']:$client['vat_id'];
		$params['payment_terms'] = (isset($override_params['payment_terms']))?$override_params['payment_terms']:$client_settings['payment_terms'];
		$params['payment_gateway'] = (isset($override_params['payment_gateway']))?$override_params['payment_gateway']:$client_settings['payment_gateway'];
		$params['status_printed'] = 'n';
		$params['status_sent'] = 'n';
		$params['status_paid'] = 'n';
		$params['invoice_amount'] = 0;
		$params['notes'] = $override_params['notes'];
		//die(print_r($params));
		
		return $this->insertQuery('../billing/form/invoice.tform.php',$client_id,$params);

	}
	
	//* Update invoice
	public function billing_invoice_update($session_id, $client_id, $invoice_id, $params) {
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice.tform.php',$client_id,$invoice_id,$params);
		return $affected_rows;
	}
	
	//* Delete invoice
	public function billing_invoice_delete($session_id, $invoice_id) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		$affected_rows = $this->deleteQuery('../billing/form/invoice.tform.php',$invoice_id);
		
		//* Delete the invoice items
		$app->db->query("DELETE FROM invoice_item WHERE invoice_id = ".$invoice_id);
		
		return $affected_rows;
	}
	
	//* Get invoice items by invoice
	public function billing_invoice_item_get_by_invoice($session_id, $invoice_id, $number = 0) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_id = intval($invoice_id);
		$number = intval($number);
		
		if($number > 0) {
			$limit_sql = "LIMIT 0,$number";
		} else {
			$limit_sql = '';
		}
		
		return $app->db->queryAllRecords("SELECT * FROM invoice_item WHERE invoice_id = $invoice_id ORDER BY invoice_item_id $limit_sql");
	}
	
	//* Get a single invoice item
	public function billing_invoice_item_get($session_id, $invoice_item_id) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		$invoice_item_id = intval($invoice_item_id);
		return $app->db->queryOneRecord("SELECT * FROM invoice_item WHERE invoice_item_id = $invoice_item_id");
	}
	
	//* Add invoice item
	public function billing_invoice_item_add($session_id, $invoice_id, $params) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_id = intval($invoice_id);
		$quantity = intval($params['quantity']);
		$price = (double)$params['price'];
		$vat = intval($params['vat']);
		$description = $app->db->quote($params['description']);
		
		$sql = "INSERT INTO invoice_item (invoice_id,quantity,price,vat,description) VALUES ($invoice_id,$quantity,'$price',$vat,'$description')";
		$app->db->query($sql);
		
		return $app->db->insertID();
	}
	
	//* Update invoice item.
	public function billing_invoice_item_update($session_id, $invoice_item_id, $params) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_item_id = intval($invoice_item_id);
		$quantity = intval($params['quantity']);
		$price = (double)$params['price'];
		$vat = intval($params['vat']);
		$description = $app->db->quote($params['description']);
		
		$sql = "UPDATE invoice_item SET quantity = $quantity, price = '$price', vat = $vat, description = '$description' WHERE invoice_item_id = $invoice_item_id)";
		$app->db->query($sql);
		
		return $app->db->affectedRows();
	}
	
	//* Delete invoice item
	public function billing_invoice_item_delete($session_id, $invoice_item_id) {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		$invoice_item_id = intval($invoice_item_id);
		
		$app->db->query("DELETE FROM invoice_item WHERE invoice_item_id = ".$invoice_item_id);
		
		return $app->db->affectedRows();
	}
	
	//* Finalize invoice
	public function billing_invoice_finalize($session_id, $invoice_id) {
		global $app, $conf;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		$invoice_id = intval($invoice_id);
		$invoice = $app->db->queryOneRecord("SELECT * FROM invoice WHERE invoice_id = ".$invoice_id);
		$company = $app->db->queryOneRecord("SELECT * FROM invoice_company WHERE invoice_company_id = ".$invoice['invoice_company_id']);
		
		// Assign a invoice number
		if($invoice['invoice_number'] == '') {
				
			if($invoice['invoice_type'] == 'refund') {
				$last_refund_number = $company['last_refund_number'];
				$refund_number_prefix = $company['refund_number_prefix'];
				$new_refund_number = $last_refund_number + 1;
				$invoice_number = $refund_number_prefix.str_pad($new_refund_number, 4, "0", STR_PAD_LEFT);
				$app->db->query("UPDATE invoice_company SET last_refund_number = $new_refund_number WHERE invoice_company_id = ".$invoice['invoice_company_id']);
			} elseif($invoice['invoice_type'] == 'proforma') {
				$last_proforma_number = $company['last_proforma_number'];
				$proforma_number_prefix = $company['proforma_number_prefix'];
				$new_proforma_number = $last_proforma_number + 1;
				$invoice_number = $proforma_number_prefix.str_pad($new_proforma_number, 4, "0", STR_PAD_LEFT);
				$app->db->query("UPDATE invoice_company SET last_proforma_number = $new_proforma_number WHERE invoice_company_id = ".$invoice['invoice_company_id']);
			} else {
				$last_invoice_number = $company['last_invoice_number'];
				$invoice_number_prefix = $company['invoice_number_prefix'];
				$new_invoice_number = $last_invoice_number + 1;
				$invoice_number = $invoice_number_prefix.str_pad($new_invoice_number, 4, "0", STR_PAD_LEFT);
				$app->db->query("UPDATE invoice_company SET last_invoice_number = $new_invoice_number WHERE invoice_company_id = ".$invoice['invoice_company_id']);
			}
			$app->db->query("UPDATE invoice SET invoice_number = '$invoice_number' WHERE invoice_id = ".$invoice_id);
		}
			
		if($invoice['invoice_date'] == '' or $invoice['invoice_date'] == '0000-00-00') {
			$invoice['invoice_date'] = date('Y-m-d');
			$app->db->query("UPDATE invoice SET invoice_date = '".$invoice['invoice_date']."' WHERE invoice_id = ".$invoice_id);
		}
	
		if($invoice['idhash'] == '') {
			// Set the unique hash for the invoice
			$idhash = md5(uniqid(mt_rand(), true));
			$app->db->query("UPDATE invoice SET idhash = '$idhash' WHERE invoice_id = ".$invoice_id);
		}
			
		// Create the PDF invoice
		$invoice_pdf_template = $company['invoice_pdf_template'];
		$pdf_invoice_classname = 'PDFInvoice_'.$invoice_pdf_template;
		
		if(!class_exists($pdf_invoice_classname)) {
			include('../billing/templates/pdf_invoice/'.$invoice_pdf_template.'/make_pdf_invoice.php');
		}
			
		$pdf=new $pdf_invoice_classname();
		$pdf->createInvoice($invoice_id);

		$pdf_content = $pdf->Output('doc.pdf','S');
		
		$app->uses('billing_functions');
		$invoice_filename = $app->billing_functions->get_invoice_filename($pdf->invoice['invoice_number'], $pdf->invoice['reminder_step']);
			
		file_put_contents($invoice_filename,$pdf_content);
		unset($pdf);

			
		// Calculate the invoice amount
		$tmp = $app->db->queryOneRecord("SELECT sum(quantity*price+(quantity*price*(vat/100))) as amount FROM invoice_item WHERE invoice_id = ".$invoice_id);
		$invoice_amount = $tmp['amount'];
			
		// Update the status of the invoice
		$app->db->query("UPDATE invoice SET status_printed = 'y', invoice_amount = $invoice_amount WHERE invoice_id = ".$invoice_id);
		
		return true;
		
	}
	
	//* Send invoice
	public function billing_invoice_send($session_id, $invoice_id, $email_template_id) {
		global $app, $conf;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_id = intval($invoice_id);
		$invoice = $app->db->queryOneRecord("SELECT * FROM invoice WHERE invoice_id = ".$invoice_id);
	
		$invoice_company_id = $invoice['invoice_company_id'];
		$client_id = $invoice['client_id'];
	
		$client = $app->db->queryOneRecord('SELECT email,contact_name,company_name FROM client WHERE client_id = '.$client_id);
		$invoice_client_settings = $app->db->queryOneRecord('SELECT * FROM invoice_client_settings WHERE client_id = '.$client_id);
		$company = $app->db->queryOneRecord('SELECT email FROM invoice_company WHERE invoice_company_id = '.$invoice_company_id);
		$email_template = $app->db->queryOneRecord('SELECT * FROM invoice_message_template WHERE invoice_message_template_id = '.$email_template_id);
		$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
	
		if ($invoice_client_settings['payment_email']) {
			$to = $invoice_client_settings['payment_email'];
		} else {
			$to = $client['email'];
		}
		$subject = $email_template['subject'];
		$text_message = str_replace("\r\n","\n",$email_template['message']);
		$from_name = $company['sender_name'];
		$from = $company['sender_email'];
		if(!$from) $from = $company['email'];
		$bcc = $company['bcc_email'];
			
		$invoice = $app->db->queryOneRecord('SELECT invoice_number,idhash,reminder_step FROM invoice WHERE invoice_id = '.$invoice_id);
		
		$app->uses('billing_functions');
		$invoice_filename = $app->billing_functions->get_invoice_filename($invoice['invoice_number'], $invoice['reminder_step']);
			
		//* Replace placeholders {INVOICE_NUMBER}, {CONTACT_NAME}, {COMPANY_NAME}
		$text_message = str_replace('{INVOICE_NUMBER}',$invoice['invoice_number'],$text_message);
		$text_message = str_replace('{CONTACT_NAME}',$client['contact_name'],$text_message);
		$text_message = str_replace('{COMPANY_NAME}',$client['company_name'],$text_message);
	
		if(isset($invoice_settings['invoice_pay_link']) && $invoice_settings['invoice_pay_link'] != '') {
			$invoice_pay_link = $invoice_settings['invoice_pay_link'].$invoice['idhash'];
		} else {
			$ispconfig_url = $app->functions->get_ispconfig_url();
			$invoice_pay_link = $ispconfig_url.'/billing/payments/pay.php?id='.$invoice['idhash'];
		}
		$text_message = str_replace('{INVOICE_PAY_LINK}',$invoice_pay_link,$text_message);
	
		//* Send the email
		$disable_invoice_sending = (isset($invoice_client_settings['no_invoice_sending']))?$invoice_client_settings['no_invoice_sending']:'n';
		
		$app->uses('functions');
		if($client['email'] != '') $app->functions->mail($to, $subject, $text_message, $from, $invoice_filename, 'application/pdf', '', '', $bcc, $from_name);
	
		//* Insert the message into the database
		$sql = "INSERT INTO `invoice_message` (`sys_userid`, `sys_groupid`, `sys_perm_user`, `sys_perm_group`, `sys_perm_other`, `invoice_company_id`, `client_id`, `message_template_id`, `message_type`, `subject`, `message`, `invoice_id`, `message_sent_date`, `message_status`) 
		VALUES(1, 1, 'riud', 'riud', '', ".$invoice_company_id.", ".$client_id.", ".$email_template_id.", 'invoice', '".$app->db->quote($subject)."', '".$app->db->quote($text_message)."', ".$invoice_id.", '".date('Y-m-d')."', 'sent');";
		$app->db->query($sql);
		
		// Update the status of the invoice
		$app->db->query("UPDATE invoice SET status_sent = 'y' WHERE invoice_id = ".$invoice_id);
		
		return true;
		
	}
	
	//* Get invoice PDF file
	public function billing_invoice_get_pdf($session_id, $invoice_id) {
		global $app, $conf;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_id = intval($invoice_id);
		$invoice = $app->db->queryOneRecord("SELECT * FROM invoice WHERE invoice_id = ".$invoice_id);
		
		if($invoice['status_printed'] != 'y') {
			$this->server->fault('invoice_not finalized', 'The invoice has to be finalized first.');
			return false;
		}
		
		$app->uses('billing_functions');
		$invoice_filename = $app->billing_functions->get_invoice_filename($invoice['invoice_number'], $invoice['reminder_step']);
		
		if(!file_exists($invoice_filename)) {
			$this->server->fault('no_such_invoice_file', 'The invoice file does not exist. Check if the invoice has been finalized.');
			return false;
		} else {
			return base64_encode(file_get_contents($invoice_filename));
		}
	}
	
	//* Set invoice status to sent
	public function billing_invoice_set_status_sent($session_id, $invoice_id, $status) {
		global $app, $conf;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_id = intval($invoice_id);
		$status = (strtolower($status) == 'y')?'y':'n';
		
		$app->db->query("UPDATE invoice SET status_sent = '$status' WHERE invoice_id = $invoice_id");
		
		return $app->db->affectedRows();
		
	}
	
	//* Set invoice status to paid
	public function billing_invoice_set_status_paid($session_id, $invoice_id, $status) {
		global $app, $conf;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$invoice_id = intval($invoice_id);
		$status = (strtolower($status) == 'y')?'y':'n';
		
		$app->db->query("UPDATE invoice SET status_paid = '$status' WHERE invoice_id = $invoice_id");
		
		return $app->db->affectedRows();
		
	}
	
	//* Get Invoice client settings
	public function billing_client_settings_get($session_id, $client_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_client_settings.tform.php');
		return $app->remoting_lib->getDataRecord($client_id);
	}
	
	//* Add Invoice client settings
	public function billing_client_settings_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_client_settings.tform.php',$client_id,$params);
	}
	
	//* Update Invoice client settings
	public function billing_client_settings_update($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_client_settings.tform.php',$client_id,$client_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice client settings
	public function billing_client_settings_delete($session_id, $client_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_client_settings.tform.php',$client_id);
		return $affected_rows;
	}
	
	//*---------------------------------------------------------------------------------------------------
	
	//* Get Invoice company
	public function billing_invoice_company_get($session_id, $primary_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_company.tform.php');
		return $app->remoting_lib->getDataRecord($primary_id);
	}
	
	//* Add Invoice company
	public function billing_invoice_company_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_company.tform.php',$client_id,$params);
	}
	
	//* Update Invoice company
	public function billing_invoice_company_update($session_id, $client_id, $primary_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_company.tform.php',$client_id,$primary_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice company
	public function billing_invoice_company_delete($session_id, $primary_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_company.tform.php',$primary_id);
		return $affected_rows;
	}
	
	//*---------------------------------------------------------------------------------------------------
	
	//* Get Invoice item_template
	public function billing_invoice_item_template_get($session_id, $primary_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_item_template.tform.php');
		return $app->remoting_lib->getDataRecord($primary_id);
	}
	
	//* Add Invoice item_template
	public function billing_invoice_item_template_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_item_template.tform.php',$client_id,$params);
	}
	
	//* Update Invoice item_template
	public function billing_invoice_item_template_update($session_id, $client_id, $primary_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_item_template.tform.php',$client_id,$primary_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice item_template
	public function billing_invoice_item_template_delete($session_id, $primary_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_item_template.tform.php',$primary_id);
		return $affected_rows;
	}
	
	//*---------------------------------------------------------------------------------------------------
	
	//* Get Invoice message_template
	public function billing_invoice_message_template_get($session_id, $primary_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_message_template.tform.php');
		return $app->remoting_lib->getDataRecord($primary_id);
	}
	
	//* Add Invoice message_template
	public function billing_invoice_message_template_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_message_template.tform.php',$client_id,$params);
	}
	
	//* Update Invoice message_template
	public function billing_invoice_message_template_update($session_id, $client_id, $primary_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_message_template.tform.php',$client_id,$primary_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice message_template
	public function billing_invoice_message_template_delete($session_id, $primary_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_message_template.tform.php',$primary_id);
		return $affected_rows;
	}
	
	//*---------------------------------------------------------------------------------------------------
	
	//* Get Invoice payment_term
	public function billing_invoice_payment_term_get($session_id, $primary_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_payment_term.tform.php');
		return $app->remoting_lib->getDataRecord($primary_id);
	}
	
	//* Add Invoice payment_term
	public function billing_invoice_payment_term_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_payment_term.tform.php',$client_id,$params);
	}
	
	//* Update Invoice payment_term
	public function billing_invoice_payment_term_update($session_id, $client_id, $primary_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_payment_term.tform.php',$client_id,$primary_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice payment_term
	public function billing_invoice_payment_term_delete($session_id, $primary_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_payment_term.tform.php',$primary_id);
		return $affected_rows;
	}
	
	//*---------------------------------------------------------------------------------------------------
	
	//* Get Invoice recurring_item
	public function billing_invoice_recurring_item_get($session_id, $primary_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_recurring_item.tform.php');
		return $app->remoting_lib->getDataRecord($primary_id);
	}
	
	//* Add Invoice recurring_item
	public function billing_invoice_recurring_item_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_recurring_item.tform.php',$client_id,$params);
	}
	
	//* Update Invoice recurring_item
	public function billing_invoice_recurring_item_update($session_id, $client_id, $primary_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_recurring_item.tform.php',$client_id,$primary_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice recurring_item
	public function billing_invoice_recurring_item_delete($session_id, $primary_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_recurring_item.tform.php',$primary_id);
		return $affected_rows;
	}
	
	//*---------------------------------------------------------------------------------------------------
	
	//* Get Invoice settings
	public function billing_invoice_settings_get($session_id, $primary_id)
    {
		global $app;
		
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$app->remoting_lib->loadFormDef('../billing/form/invoice_settings.tform.php');
		return $app->remoting_lib->getDataRecord($primary_id);
	}
	
	//* Add Invoice settings
	public function billing_invoice_settings_add($session_id, $client_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		return $this->insertQuery('../billing/form/invoice_settings.tform.php',$client_id,$params);
	}
	
	//* Update Invoice settings
	public function billing_invoice_settings_update($session_id, $client_id, $primary_id, $params)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->updateQuery('../billing/form/invoice_settings.tform.php',$client_id,$primary_id,$params);
		return $affected_rows;
	}
	
	//* Delete Invoice settings
	public function billing_invoice_settings_delete($session_id, $primary_id)
    {
		if(!$this->checkPerm($session_id, 'billing')) {
			$this->server->fault('permission_denied', 'You do not have the permissions to access this function.');
			return false;
		}
		
		$affected_rows = $this->deleteQuery('../billing/form/invoice_settings.tform.php',$primary_id);
		return $affected_rows;
	}
	
	


}



?>