<?php
if(isset($_SERVER["REMOTE_ADDR"]) || isset($_SERVER["SERVER_ADDR"])){
    die("Permission denied");
};

define('SCRIPT_PATH', dirname(__FILE__));
define('CRON_RUN', true);

require_once(SCRIPT_PATH.'/../../../lib/config.inc.php');
require_once(SCRIPT_PATH.'/../../../lib/app.inc.php');
$app->uses('functions');

$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
$reminders = $app->db->queryAllRecords("SELECT * FROM invoice_recurring_item WHERE send_reminder != '' AND send_reminder != '0' AND active = 'y'");

if(is_array($reminders) && !empty($reminders)){
	foreach($reminders as $reminder){
		
		
		
		
		
		$days = trim($reminder['send_reminder']);
		$now = date('Y-m-d');
		list($now_jahr,$now_monat,$now_tag) = explode('-',$now);
		$now = mktime(0, 0, 0, $now_monat, $now_tag, $now_jahr);
		
		list($start_jahr,$start_monat,$start_tag) = explode('-',$reminder['start_date']);
		$start_date = mktime(0, 0, 0, $start_monat, $start_tag, $start_jahr);
		
		if($reminder['end_date'] == '' or $reminder['end_date'] == '0000-00-00') {
			$end_date = false;
		} else {
			list($end_jahr,$end_monat,$end_tag) = explode('-',$reminder['end_date']);
			$end_date = mktime(0, 0, 0, $end_monat, $end_tag, $end_jahr);
		}
		
		if($reminder['next_payment_date'] == '' or $reminder['next_payment_date'] == '0000-00-00') {
			$next_payment_date = false;
		} else {
			list($np_jahr,$np_monat,$np_tag) = explode('-',$reminder['next_payment_date']);
			$next_payment_date = mktime(0, 0, 0, $np_monat, $np_tag, $np_jahr);
		}
		
		if(!$next_payment_date && !$end_date) continue;
		
		// multiple values?
		if(strpos($days, ',') !== false){
			$multiple_days = explode(',', $days);
			foreach($multiple_days as $single_day){
				$single_day = trim($single_day);
				if(is_numeric($single_day) && $single_day > 0){
					if(($next_payment_date && ($next_payment_date - ($single_day * 86400)) >= $now && ($next_payment_date - ($single_day * 86400)) < ($now + 86400)) || ($end_date && ($end_date - ($single_day * 86400)) >= $now && ($end_date - ($single_day * 86400)) < ($now + 86400))){
						// send reminder
						$company = $app->db->queryOneRecord("SELECT * FROM invoice_company WHERE invoice_company_id = ".$reminder['invoice_company_id']);
						$lng = strtolower($company['country']);
						$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$reminder['client_id']);
						$subject = lng('recurring_item_about_to_renew_expire_txt', $lng);
						$text_message = lng('the_following_item_is_about_to_renew_expire_txt', $lng).':

============= '.lng('Item', $lng).' =============
'.lng('name_txt', $lng).': '.$reminder['name'].'
'.lng('quantity_txt', $lng).': '.$reminder['quantity'].'
'.lng('price_txt', $lng).': '.$app->functions->currency_format($reminder['price'], 'client').' '.$invoice_settings['currency'].'
'.lng('vat_txt', $lng).': '.$app->functions->currency_format($reminder['vat'], 'client').' %
'.lng('setup_fee_txt', $lng).': '.$app->functions->currency_format($reminder['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.lng('recur_months_txt', $lng).': '.$reminder['recur_months'].' '.lng('months_txt', $lng).'
'.lng('cancellation_period_txt', $lng).': '.$reminder['cancellation_period'].' '.lng('days_txt', $lng).'
'.lng('start_date_txt', $lng).': '.date(lng('conf_format_dateshort', $lng),$start_date).'
'.lng('next_payment_date_txt', $lng).': '.($next_payment_date? date(lng('conf_format_dateshort', $lng),$next_payment_date): '-').'
'.lng('end_date_txt', $lng).': '.($end_date? date(lng('conf_format_dateshort', $lng),$end_date): '-').'
============= '.lng('Item', $lng).' =============

============= '.lng('client_id_txt', $lng).' =============
'.lng('company_name_txt', $lng).': '.$client['company_name'].'
'.lng('contact_name_txt', $lng).': '.$client['contact_name'].'
'.lng('customer_no_txt', $lng).': '.$client['customer_no'].'
'.lng('street_txt', $lng).': '.$client['street'].'
'.lng('zip_txt', $lng).': '.$client['zip'].'
'.lng('city_txt', $lng).': '.$client['city'].'
'.lng('state_txt', $lng).': '.$client['state'].'
'.lng('country_txt', $lng).': '.$client['country'].'
'.lng('telephone_txt', $lng).': '.$client['telephone'].'
'.lng('mobile_txt', $lng).': '.$client['mobile'].'
'.lng('fax_txt', $lng).': '.$client['fax'].'
'.lng('email_txt', $lng).': '.$client['email'].'
'.lng('internet_txt', $lng).': '.$client['internet'].'
'.lng('icq_txt', $lng).': '.$client['icq'].'
'.lng('vat_id_txt', $lng).': '.$client['vat_id'].'
'.lng('company_id_txt', $lng).': '.$client['company_id'].'
'.lng('bank_account_owner_txt', $lng).': '.$client['bank_account_owner'].'
'.lng('bank_account_number_txt', $lng).': '.$client['bank_account_number'].'
'.lng('bank_code_txt', $lng).': '.$client['bank_code'].'
'.lng('bank_name_txt', $lng).': '.$client['bank_name'].'
'.lng('bank_account_iban_txt', $lng).': '.$client['bank_account_iban'].'
'.lng('bank_account_swift_txt', $lng).': '.$client['bank_account_swift'].'
'.lng('paypal_email_txt', $lng).': '.$client['paypal_email'].'
============= '.lng('client_id_txt', $lng).' =============
';

						$app->functions->mail(trim($company['email']), $subject, $text_message, (trim($company['sender_email']) != ''? trim($company['sender_email']):trim($company['email'])), '', 'application/pdf', '', '', trim($company['bcc_email']), (trim($company['sender_name']) != ''? trim($company['sender_name']):trim($company['email'])));
					}
					
				}
			}
		} else {
			if(is_numeric($days) && $days > 0){
				if(($next_payment_date && ($next_payment_date - ($days * 86400)) >= $now && ($next_payment_date - ($days * 86400)) < ($now + 86400)) || ($end_date && ($end_date - ($days * 86400)) >= $now && ($end_date - ($days * 86400)) < ($now + 86400))){
					// send reminder
					$company = $app->db->queryOneRecord("SELECT * FROM invoice_company WHERE invoice_company_id = ".$reminder['invoice_company_id']);
					$lng = strtolower($company['country']);
					$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$reminder['client_id']);
					$subject = lng('recurring_item_about_to_renew_expire_txt', $lng);
					$text_message = lng('the_following_item_is_about_to_renew_expire_txt', $lng).':

============= '.lng('Item', $lng).' =============
'.lng('name_txt', $lng).': '.$reminder['name'].'
'.lng('quantity_txt', $lng).': '.$reminder['quantity'].'
'.lng('price_txt', $lng).': '.$app->functions->currency_format($reminder['price'], 'client').' '.$invoice_settings['currency'].'
'.lng('vat_txt', $lng).': '.$app->functions->currency_format($reminder['vat'], 'client').' %
'.lng('setup_fee_txt', $lng).': '.$app->functions->currency_format($reminder['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.lng('recur_months_txt', $lng).': '.$reminder['recur_months'].' '.lng('months_txt', $lng).'
'.lng('cancellation_period_txt', $lng).': '.$reminder['cancellation_period'].' '.lng('days_txt', $lng).'
'.lng('start_date_txt', $lng).': '.date(lng('conf_format_dateshort', $lng),$start_date).'
'.lng('next_payment_date_txt', $lng).': '.($next_payment_date? date(lng('conf_format_dateshort', $lng),$next_payment_date): '-').'
'.lng('end_date_txt', $lng).': '.($end_date? date(lng('conf_format_dateshort', $lng),$end_date): '-').'
============= '.lng('Item', $lng).' =============

============= '.lng('client_id_txt', $lng).' =============
'.lng('company_name_txt', $lng).': '.$client['company_name'].'
'.lng('contact_name_txt', $lng).': '.$client['contact_name'].'
'.lng('customer_no_txt', $lng).': '.$client['customer_no'].'
'.lng('street_txt', $lng).': '.$client['street'].'
'.lng('zip_txt', $lng).': '.$client['zip'].'
'.lng('city_txt', $lng).': '.$client['city'].'
'.lng('state_txt', $lng).': '.$client['state'].'
'.lng('country_txt', $lng).': '.$client['country'].'
'.lng('telephone_txt', $lng).': '.$client['telephone'].'
'.lng('mobile_txt', $lng).': '.$client['mobile'].'
'.lng('fax_txt', $lng).': '.$client['fax'].'
'.lng('email_txt', $lng).': '.$client['email'].'
'.lng('internet_txt', $lng).': '.$client['internet'].'
'.lng('icq_txt', $lng).': '.$client['icq'].'
'.lng('vat_id_txt', $lng).': '.$client['vat_id'].'
'.lng('company_id_txt', $lng).': '.$client['company_id'].'
'.lng('bank_account_owner_txt', $lng).': '.$client['bank_account_owner'].'
'.lng('bank_account_number_txt', $lng).': '.$client['bank_account_number'].'
'.lng('bank_code_txt', $lng).': '.$client['bank_code'].'
'.lng('bank_name_txt', $lng).': '.$client['bank_name'].'
'.lng('bank_account_iban_txt', $lng).': '.$client['bank_account_iban'].'
'.lng('bank_account_swift_txt', $lng).': '.$client['bank_account_swift'].'
'.lng('paypal_email_txt', $lng).': '.$client['paypal_email'].'
============= '.lng('client_id_txt', $lng).' =============
';
					
					$app->functions->mail(trim($company['email']), $subject, $text_message, (trim($company['sender_email']) != ''? trim($company['sender_email']):trim($company['email'])), '', 'application/pdf', '', '', trim($company['bcc_email']), (trim($company['sender_name']) != ''? trim($company['sender_name']):trim($company['email'])));	
				}
				
			}
		}
	}
} else {
	die("No reminders to send!\n");
}

function lng($text, $lng = 'en') {
	global $conf;
	
	if(is_file(ISPC_LIB_PATH.'/lang/'.strtolower($lng).'.lng')) {
		include(ISPC_LIB_PATH.'/lang/'.strtolower($lng).'.lng');
	} else {
		include(ISPC_LIB_PATH.'/lang/'.$conf['language'].'.lng');
	}
		
	if(is_file(ISPC_WEB_PATH.'/billing/lib/lang/'.strtolower($lng).'.lng')) {
		include(ISPC_WEB_PATH.'/billing/lib/lang/'.strtolower($lng).'.lng');
	} else {
		include(ISPC_WEB_PATH.'/billing/lib/lang/'.$conf['language'].'.lng');
	}
			
	if(is_file(ISPC_WEB_PATH.'/billing/lib/lang/'.strtolower($lng).'_invoice_recurring_item.lng')) {
		include(ISPC_WEB_PATH.'/billing/lib/lang/'.strtolower($lng).'_invoice_recurring_item.lng');
	} else {
		include(ISPC_WEB_PATH.'/billing/lib/lang/'.$conf['language'].'_invoice_recurring_item.lng');
	}
	
	if(isset($wb[$text])) {
		return $wb[$text];
	} else {
		return $text;
	}
}
?>