<?php
/*
Copyright (c) 2005 - 2008, Till Brehm, projektfarm Gmbh
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of ISPConfig nor the names of its contributors
      may be used to endorse or promote products derived from this software without
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/******************************************
* Begin Form configuration
******************************************/

$tform_def_file = "form/dashboard_client.tform.php";

/******************************************
* End Form configuration
******************************************/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');
//print_r($_SESSION);
//* Check permissions for module
$app->auth->check_module_permissions('dashboard');

// Loading classes
$app->uses('tpl,tform,tform_actions');
$app->load('tform_actions');

class page_action extends tform_actions {

	function onLoad() {
                global $app, $conf, $tform_def_file;

                // Loading template classes and initialize template
                if(!is_object($app->tpl)) $app->uses('tpl');
                if(!is_object($app->tform)) $app->uses('tform');

                $app->tpl->newTemplate("tabbed_form.tpl.htm");

                // Load table definition from file
                $app->tform->loadFormDef($tform_def_file);
				
				// Importing ID
                $this->id = $_SESSION['s']['user']['client_id'];

                if(count($_POST) > 1) {
                        $this->dataRecord = $_POST;
                        $this->onSubmit();
                } else {
                        $this->onShow();
                }
        }

	function onShowNew() {
		global $app, $conf;
		
		// we will check only users, not admins
		if($_SESSION["s"]["user"]["typ"] == 'user') {
			
			// Get the limits of the client
			$client_group_id = $_SESSION["s"]["user"]["default_group"];
			$client = $app->db->queryOneRecord("SELECT limit_client FROM sys_group, client WHERE sys_group.client_id = client.client_id and sys_group.groupid = $client_group_id");
			
			// Check if the user may add another website.
			if($client["limit_client"] >= 0) {
				$tmp = $app->db->queryOneRecord("SELECT count(client_id) as number FROM client WHERE sys_groupid = $client_group_id");
				if($tmp["number"] >= $client["limit_client"]) {
					$app->error($app->tform->wordbook["limit_client_txt"]);
				}
			}
		}
		
		parent::onShowNew();
	}
	
	
	function onSubmit() {
		global $app, $conf;
		
		// we will check only users, not admins
		if($_SESSION["s"]["user"]["typ"] == 'user' && $this->id == 0) {
			
			// Get the limits of the client
			$client_group_id = $_SESSION["s"]["user"]["default_group"];
			$client = $app->db->queryOneRecord("SELECT limit_client FROM sys_group, client WHERE sys_group.client_id = client.client_id and sys_group.groupid = $client_group_id");
			
			// Check if the user may add another website.
			if($client["limit_client"] >= 0) {
				$tmp = $app->db->queryOneRecord("SELECT count(client_id) as number FROM client WHERE sys_groupid = $client_group_id");
				if($tmp["number"] >= $client["limit_client"]) {
					$app->error($app->tform->wordbook["limit_client_txt"]);
				}
			}
		}
		
		parent::onSubmit();
	}

	function onShowEnd() {

		global $app;

		$sql = "SELECT template_id,template_name FROM client_template WHERE template_type = 'a'";
		$tpls = $app->db->queryAllRecords($sql);
		$option = '';
		$tpl = array();
		foreach($tpls as $item){
			$option .= '<option value="' . $item['template_id'] . '|' .  $item['template_name'] . '">' . $item['template_name'] . '</option>';
			$tpl[$item['template_id']] = $item['template_name'];
		}
		$app->tpl->setVar('tpl_add_select',$option);
		$app->tpl->setVar('customer_no',$this->dataRecord['customer_no']);

		$sql = "SELECT template_additional FROM client WHERE client_id = " . $this->id;
		$result = $app->db->queryOneRecord($sql);
		$tplAdd = explode("/", $result['template_additional']);
		$text = '';
		foreach($tplAdd as $item){
			if (trim($item) != ''){
				if ($text != '') $text .= '<br />';
				$text .= $tpl[$item];
			}
		}

		$app->tpl->setVar('template_additional_list', $text);
		$app->tpl->setVar('app_module','client');

		parent::onShowEnd();

	}
	
	
	/*
	 This function is called automatically right after
	 the data was updated successfully in the database.
	*/
	function onAfterUpdate() {
		global $app;
		
		$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_dashboard_client.lng';
		if(is_file($lng_file)) include($lng_file);
		
		// send email with old and new customer values to the company that belongs to the customer
		$email = $app->db->queryOneRecord("SELECT invoice_company.email, invoice_company.bcc_email FROM invoice_company, invoice_client_settings WHERE invoice_client_settings.client_id = ".$this->id." AND invoice_client_settings.invoice_company_id = invoice_company.invoice_company_id");
		
		if(is_array($email) && !empty($email)){
			$email_subject = $app->tform->wordbook['subject_data_modification_txt'];
			$email_msg = $app->tform->wordbook['body_data_modification_date_txt'].': '.date($app->lng('conf_format_dateshort').' '.$app->lng('conf_format_timelong')).'
			
'.$app->tform->wordbook['body_data_modification_the_customer_txt'].' 

============= '.$app->tform->wordbook['body_data_modification_old_txt'].' =============
'.$app->tform->wordbook['company_name_txt'].': '.$this->oldDataRecord['company_name'].'
'.$app->tform->wordbook['contact_name_txt'].': '.$this->oldDataRecord['contact_name'].'
'.$app->tform->wordbook['customer_no_txt'].': '.$this->oldDataRecord['customer_no'].'
'.$app->tform->wordbook['street_txt'].': '.$this->oldDataRecord['street'].'
'.$app->tform->wordbook['zip_txt'].': '.$this->oldDataRecord['zip'].'
'.$app->tform->wordbook['city_txt'].': '.$this->oldDataRecord['city'].'
'.$app->tform->wordbook['state_txt'].': '.$this->oldDataRecord['state'].'
'.$app->tform->wordbook['country_txt'].': '.$this->oldDataRecord['country'].'
'.$app->tform->wordbook['telephone_txt'].': '.$this->oldDataRecord['telephone'].'
'.$app->tform->wordbook['mobile_txt'].': '.$this->oldDataRecord['mobile'].'
'.$app->tform->wordbook['fax_txt'].': '.$this->oldDataRecord['fax'].'
'.$app->tform->wordbook['email_txt'].': '.$this->oldDataRecord['email'].'
'.$app->tform->wordbook['internet_txt'].': '.$this->oldDataRecord['internet'].'
'.$app->tform->wordbook['icq_txt'].': '.$this->oldDataRecord['icq'].'
'.$app->tform->wordbook['vat_id_txt'].': '.$this->oldDataRecord['vat_id'].'
'.$app->tform->wordbook['company_id_txt'].': '.$this->oldDataRecord['company_id'].'
'.$app->tform->wordbook['bank_account_owner_txt'].': '.$this->oldDataRecord['bank_account_owner'].'
'.$app->tform->wordbook['bank_account_number_txt'].': '.$this->oldDataRecord['bank_account_number'].'
'.$app->tform->wordbook['bank_code_txt'].': '.$this->oldDataRecord['bank_code'].'
'.$app->tform->wordbook['bank_name_txt'].': '.$this->oldDataRecord['bank_name'].'
'.$app->tform->wordbook['bank_account_iban_txt'].': '.$this->oldDataRecord['bank_account_iban'].'
'.$app->tform->wordbook['bank_account_swift_txt'].': '.$this->oldDataRecord['bank_account_swift'].'
'.$app->tform->wordbook['paypal_email_txt'].': '.$this->oldDataRecord['paypal_email'].'


'.$app->tform->wordbook['body_data_modification_has_modified_the_following_data_txt'].':

============= '.$app->tform->wordbook['body_data_modification_new_txt'].' =============
';
			foreach($this->dataRecord as $key => $val){
				if($this->oldDataRecord[$key] != $val && $key != 'id' && $key != 'phpsessid') $email_msg .= $app->tform->wordbook[$key.'_txt'].': '.$val."\n";
			}
			$app->functions->mail(trim($email['email']), $email_subject, $email_msg, $this->oldDataRecord['email'], '', 'application/pdf', '', '', trim($email['bcc_email']));
		}
		
		/*
		 *  If there is a client-template, process it */
        $app->uses('client_templates');
        $app->client_templates->apply_client_templates($this->id);

		parent::onAfterUpdate();
	}
}

$page = new page_action;
$page->onLoad();

?>
