<?php
/*
Copyright (c) 2005 - 2008, Till Brehm, projektfarm Gmbh
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of ISPConfig nor the names of its contributors
      may be used to endorse or promote products derived from this software without
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/******************************************
* Begin Form configuration
******************************************/

$tform_def_file = "form/dashboard_order.tform.php";

/******************************************
* End Form configuration
******************************************/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');

//print_r($_SESSION);
//* Check permissions for module
$app->auth->check_module_permissions('dashboard');

// Loading classes
$app->uses('tpl,tform,tform_actions');
$app->load('tform_actions');

//$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
$app->tform->dateformat = $app->lng('conf_format_dateshort');

class page_action extends tform_actions {
	
	function onShowEnd() {
		global $app, $conf;
		//if($this->dataRecord['client_id'] != $_SESSION['s']['user']['client_id']) $app->error($app->tform->wordbook["error_client_id_mismatch_txt"].' ','javascript:loadContent(\'dashboard/dashboard.php\');');
		
		$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		$app->tpl->setVar('currency_txt',$invoice_settings['currency']);
				
		$app->tpl->setVar('name',$this->dataRecord['name']);
		$app->tpl->setVar('quantity',$this->dataRecord['quantity']);
		$app->tpl->setVar('price',$app->functions->currency_format($this->dataRecord['price'], 'client'));
		$app->tpl->setVar('setup_fee',$app->functions->currency_format($this->dataRecord['setup_fee'], 'client'));
		$app->tpl->setVar('vat',$app->functions->currency_format($this->dataRecord['vat'], 'client'));
		$app->tpl->setVar('recur_months',$this->dataRecord['recur_months']);
		$app->tpl->setVar('type',$this->dataRecord['type']);
		$app->tpl->setVar('unit',$this->dataRecord['unit']);
		$app->tpl->setVar('cancellation_period',$this->dataRecord['cancellation_period']);		

		 parent::onShowEnd();
	}
	
	function onSubmit() {
		global $app;
		
		$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_dashboard_order.lng';
		if(is_file($lng_file)) include($lng_file);
		
		// send email with old and new customer values to the company that belongs to the customer
		$email = $app->db->queryOneRecord("SELECT invoice_company.email, invoice_company.sender_name, invoice_company.sender_email, invoice_company.bcc_email FROM invoice_company, invoice_client_settings WHERE invoice_client_settings.client_id = ".$_SESSION['s']['user']['client_id']." AND invoice_client_settings.invoice_company_id = invoice_company.invoice_company_id");
		
		$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$_SESSION['s']['user']['client_id']);
		
		$product = $app->db->queryOneRecord("SELECT * FROM invoice_item_template WHERE invoice_item_template_id = ".$this->id);
		
		$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
		if(is_array($email) && !empty($email) && $client['email'] != ''){
			$company_email_subject = $app->tform->wordbook['subject_product_order_txt'].': '.$product['name'];
			$client_email_subject = $app->tform->wordbook['client_subject_product_order_txt'].': '.$product['name'];
				
			$company_email_msg = $app->tform->wordbook['body_product_order_the_customer_txt'].' 

'.$app->tform->wordbook['company_name_txt'].': '.$client['company_name'].'
'.$app->tform->wordbook['contact_name_txt'].': '.$client['contact_name'].'
'.$app->tform->wordbook['customer_no_txt'].': '.$client['customer_no'].'
'.$app->tform->wordbook['street_txt'].': '.$client['street'].'
'.$app->tform->wordbook['zip_txt'].': '.$client['zip'].'
'.$app->tform->wordbook['city_txt'].': '.$client['city'].'
'.$app->tform->wordbook['state_txt'].': '.$client['state'].'
'.$app->tform->wordbook['country_txt'].': '.$client['country'].'
'.$app->tform->wordbook['telephone_txt'].': '.$client['telephone'].'
'.$app->tform->wordbook['mobile_txt'].': '.$client['mobile'].'
'.$app->tform->wordbook['fax_txt'].': '.$client['fax'].'
'.$app->tform->wordbook['email_txt'].': '.$client['email'].'
'.$app->tform->wordbook['internet_txt'].': '.$client['internet'].'
'.$app->tform->wordbook['icq_txt'].': '.$client['icq'].'
'.$app->tform->wordbook['vat_id_txt'].': '.$client['vat_id'].'
'.$app->tform->wordbook['company_id_txt'].': '.$client['company_id'].'
'.$app->tform->wordbook['bank_account_owner_txt'].': '.$client['bank_account_owner'].'
'.$app->tform->wordbook['bank_account_number_txt'].': '.$client['bank_account_number'].'
'.$app->tform->wordbook['bank_code_txt'].': '.$client['bank_code'].'
'.$app->tform->wordbook['bank_name_txt'].': '.$client['bank_name'].'
'.$app->tform->wordbook['bank_account_iban_txt'].': '.$client['bank_account_iban'].'
'.$app->tform->wordbook['bank_account_swift_txt'].': '.$client['bank_account_swift'].'
'.$app->tform->wordbook['paypal_email_txt'].': '.$client['paypal_email'].'

'.$app->tform->wordbook['body_product_order_has_ordered_the_following_product_txt'].'

'.$app->tform->wordbook['name_txt'].': '.$product['name'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($product['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($product['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($product['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$product['recur_months'].' '.$app->tform->wordbook['months_txt'].'
'.$app->tform->wordbook['cancellation_period_txt'].': '.$product['cancellation_period'].' '.$app->tform->wordbook['days_txt'];

			$client_email_msg = $app->tform->wordbook['body_product_order_you_have_ordered_the_following_product_txt'].'

'.$app->tform->wordbook['name_txt'].': '.$product['name'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($product['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($product['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($product['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$product['recur_months'].' '.$app->tform->wordbook['months_txt'].'
'.$app->tform->wordbook['cancellation_period_txt'].': '.$product['cancellation_period'].' '.$app->tform->wordbook['days_txt'].'

'.$app->tform->wordbook['body_product_order_client_data_txt'].'

'.$app->tform->wordbook['company_name_txt'].': '.$client['company_name'].'
'.$app->tform->wordbook['contact_name_txt'].': '.$client['contact_name'].'
'.$app->tform->wordbook['customer_no_txt'].': '.$client['customer_no'].'
'.$app->tform->wordbook['street_txt'].': '.$client['street'].'
'.$app->tform->wordbook['zip_txt'].': '.$client['zip'].'
'.$app->tform->wordbook['city_txt'].': '.$client['city'].'
'.$app->tform->wordbook['state_txt'].': '.$client['state'].'
'.$app->tform->wordbook['country_txt'].': '.$client['country'].'
'.$app->tform->wordbook['telephone_txt'].': '.$client['telephone'].'
'.$app->tform->wordbook['mobile_txt'].': '.$client['mobile'].'
'.$app->tform->wordbook['fax_txt'].': '.$client['fax'].'
'.$app->tform->wordbook['email_txt'].': '.$client['email'].'
'.$app->tform->wordbook['internet_txt'].': '.$client['internet'].'
'.$app->tform->wordbook['icq_txt'].': '.$client['icq'].'
'.$app->tform->wordbook['vat_id_txt'].': '.$client['vat_id'].'
'.$app->tform->wordbook['company_id_txt'].': '.$client['company_id'].'
'.$app->tform->wordbook['bank_account_owner_txt'].': '.$client['bank_account_owner'].'
'.$app->tform->wordbook['bank_account_number_txt'].': '.$client['bank_account_number'].'
'.$app->tform->wordbook['bank_code_txt'].': '.$client['bank_code'].'
'.$app->tform->wordbook['bank_name_txt'].': '.$client['bank_name'].'
'.$app->tform->wordbook['bank_account_iban_txt'].': '.$client['bank_account_iban'].'
'.$app->tform->wordbook['bank_account_swift_txt'].': '.$client['bank_account_swift'].'
'.$app->tform->wordbook['paypal_email_txt'].': '.$client['paypal_email'];

			// email company
			$app->functions->mail(trim($email['email']), $company_email_subject, $company_email_msg, trim($client['email']), '', 'application/pdf', '', '', trim($email['bcc_email']), trim($client['contact_name']));
			
            $from = trim($email['sender_email']);
            if(!$from) $from = trim($email['email']);
            $from_name = trim($email['sender_name']);
            
			// email client
			$app->functions->mail(trim($client['email']), $client_email_subject, $client_email_msg, $from, '', 'application/pdf', '', '', trim($email['bcc_email']), $from_name);
		}
		
		parent::onSubmit();
	}
	
	

}

$page = new page_action;
$page->onLoad();

?>
