<?php
/*
Copyright (c) 2005 - 2008, Till Brehm, projektfarm Gmbh
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of ISPConfig nor the names of its contributors
      may be used to endorse or promote products derived from this software without
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/******************************************
* Begin Form configuration
******************************************/

$tform_def_file = "form/dashboard_product.tform.php";

/******************************************
* End Form configuration
******************************************/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');
//print_r($_SESSION);
//* Check permissions for module
$app->auth->check_module_permissions('dashboard');

// Loading classes
$app->uses('tpl,tform,tform_actions');
$app->load('tform_actions');

//$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
$app->tform->dateformat = $app->lng('conf_format_dateshort');

class page_action extends tform_actions {
	
	function onShowEnd() {
                global $app, $conf;
				if($this->dataRecord['client_id'] != $_SESSION['s']['user']['client_id']) $app->error($app->tform->wordbook["error_record_not_owned_by_you_txt"].' ','javascript:loadContent(\'dashboard/dashboard.php\');');
				
				$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
				$app->tpl->setVar('date_format_txt',$app->lng('conf_format_dateshort_human_readable'));
				$app->tpl->setVar('currency_txt',$invoice_settings['currency']);
				
				$app->tpl->setVar('name',$this->dataRecord['name']);
				$app->tpl->setVar('quantity',$this->dataRecord['quantity']);
				$app->tpl->setVar('price',$app->functions->currency_format($this->dataRecord['price'], 'client'));
				$app->tpl->setVar('setup_fee',$app->functions->currency_format($this->dataRecord['setup_fee'], 'client'));
				$app->tpl->setVar('vat',$app->functions->currency_format($this->dataRecord['vat'], 'client'));
				$app->tpl->setVar('recur_months',$this->dataRecord['recur_months']);
				$app->tpl->setVar('type',$this->dataRecord['type']);
				$app->tpl->setVar('submit_confirmation',$app->lng('submit_confirmation'));
				
				
				$tmp = explode('-',$this->dataRecord['next_payment_date']);
				$app->tpl->setVar('next_payment_date',date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0])));
				$tmp = explode('-',$this->dataRecord['start_date']);
				$app->tpl->setVar('start_date',date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0])));
				
				if($this->dataRecord['end_date'] != '' && $this->dataRecord['end_date'] != '0000-00-00'){
					$tmp = explode('-',$this->dataRecord['end_date']);
					$app->tpl->setVar('termination_date',date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0])));
					$app->tpl->setVar('terminated',1);
				} else {
				
				// Compute possible cancellation dates
				$start_date_tmp = explode('-',$this->dataRecord['start_date']);
				$start_date_timestamp = mktime(0, 0, 0, $start_date_tmp[1], $start_date_tmp[2], $start_date_tmp[0]);
				$cancellation_period = $this->dataRecord['cancellation_period'] * 86400;
				$current_date_tmp = explode('-',date('Y-m-d'));
				$current_date_timestamp = mktime(0, 0, 0, $current_date_tmp[1], $current_date_tmp[2], $current_date_tmp[0]);
				
				$end_date_tmp = explode('-',$this->dataRecord['end_date']);
				$end_date_formatted = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $end_date_tmp[1], $end_date_tmp[2], $end_date_tmp[0]));
				
				$recur_period = $this->dataRecord['recur_months'] * 30.4375 * 86400; //(3*365+366)/48=30.4375
				$no_of_periods_passed = floor(($current_date_timestamp - $start_date_timestamp)/$recur_period);
				if($current_date_timestamp < ($start_date_timestamp + (($no_of_periods_passed + 1) * $recur_period) - $cancellation_period)){
					$next_possible_cancellation_period = $no_of_periods_passed + 1;
				} else {
					$next_possible_cancellation_period = $no_of_periods_passed + 2;
				}
				if($this->dataRecord['end_date'] == '0000-00-00'){
					$cancellation_dates = '<option value="">--</option>';
					for($i=0;$i<12;$i++){
						$cncl_date = date($app->lng('conf_format_dateshort'), $start_date_timestamp + ($next_possible_cancellation_period + $i) * $recur_period);
						$cancellation_dates .= '<option value="'.$cncl_date.'"'.($end_date_formatted == $cncl_date? ' selected="selected"':'').'>'.$cncl_date.'</option>';
					}
				} else {
					$cancellation_dates = '<option value="'.$end_date_formatted.'" selected="selected">'.$end_date_formatted.'</option>';
				}
				
				/*
				$no_of_periods_passed = ($current_date_timestamp - $start_date_timestamp)/$cancellation_period;
				if(floor($no_of_periods_passed) == $no_of_periods_passed){
					$next_possible_cancellation_period = floor($no_of_periods_passed) + 1;
				} else {
					$next_possible_cancellation_period = floor($no_of_periods_passed) + 2;
				}
				if($this->dataRecord['end_date'] == '0000-00-00'){
					$cancellation_dates = '<option value="">--</option>';
					for($i=0;$i<12;$i++){
						$cncl_date = date($app->lng('conf_format_dateshort'), $start_date_timestamp + ($next_possible_cancellation_period + $i) * $cancellation_period);
						$cancellation_dates .= '<option value="'.$cncl_date.'"'.($end_date_formatted == $cncl_date? ' selected="selected"':'').'>'.$cncl_date.'</option>';
					}
				} else {
					$cancellation_dates = '<option value="'.$end_date_formatted.'" selected="selected">'.$end_date_formatted.'</option>';
				}
				*/
				$app->tpl->setVar('end_date',$cancellation_dates);
				}
				
				// Datepicker
				$date_format = $app->lng('conf_format_dateshort');
				$trans = array("d" => "dd", "m" => "mm", "Y" => "yy");
				$date_format = strtr($date_format, $trans);
				$app->tpl->setVar("date_format", $date_format);		
		
				$app->tpl->setVar("daynamesmin_su", $app->lng('daynamesmin_su'));
				$app->tpl->setVar("daynamesmin_mo", $app->lng('daynamesmin_mo'));
				$app->tpl->setVar("daynamesmin_tu", $app->lng('daynamesmin_tu'));
				$app->tpl->setVar("daynamesmin_we", $app->lng('daynamesmin_we'));
				$app->tpl->setVar("daynamesmin_th", $app->lng('daynamesmin_th'));
				$app->tpl->setVar("daynamesmin_fr", $app->lng('daynamesmin_fr'));
				$app->tpl->setVar("daynamesmin_sa", $app->lng('daynamesmin_sa'));
		
				$app->tpl->setVar("daynames_sunday", $app->lng('daynames_sunday'));
				$app->tpl->setVar("daynames_monday", $app->lng('daynames_monday'));
				$app->tpl->setVar("daynames_tuesday", $app->lng('daynames_tuesday'));
				$app->tpl->setVar("daynames_wednesday", $app->lng('daynames_wednesday'));
				$app->tpl->setVar("daynames_thursday", $app->lng('daynames_thursday'));
				$app->tpl->setVar("daynames_friday", $app->lng('daynames_friday'));
				$app->tpl->setVar("daynames_saturday", $app->lng('daynames_saturday'));
		
				$app->tpl->setVar("monthnamesshort_jan", $app->lng('monthnamesshort_jan'));
				$app->tpl->setVar("monthnamesshort_feb", $app->lng('monthnamesshort_feb'));
				$app->tpl->setVar("monthnamesshort_mar", $app->lng('monthnamesshort_mar'));
				$app->tpl->setVar("monthnamesshort_apr", $app->lng('monthnamesshort_apr'));
				$app->tpl->setVar("monthnamesshort_may", $app->lng('monthnamesshort_may'));
				$app->tpl->setVar("monthnamesshort_jun", $app->lng('monthnamesshort_jun'));
				$app->tpl->setVar("monthnamesshort_jul", $app->lng('monthnamesshort_jul'));
				$app->tpl->setVar("monthnamesshort_aug", $app->lng('monthnamesshort_aug'));
				$app->tpl->setVar("monthnamesshort_sep", $app->lng('monthnamesshort_sep'));
				$app->tpl->setVar("monthnamesshort_oct", $app->lng('monthnamesshort_oct'));
				$app->tpl->setVar("monthnamesshort_nov", $app->lng('monthnamesshort_nov'));
				$app->tpl->setVar("monthnamesshort_dec", $app->lng('monthnamesshort_dec'));		
		
				$app->tpl->setVar("datepicker_nextText", $app->lng('datepicker_nextText'));
				$app->tpl->setVar("datepicker_prevText", $app->lng('datepicker_prevText'));
				
				$addons = $app->db->queryAllRecords("SELECT * FROM invoice_item_template WHERE offer_in_shop = 'y' AND is_addon = 'y' AND (addon_of = '".$this->dataRecord['invoice_item_template_id']."' OR addon_of LIKE '".$this->dataRecord['invoice_item_template_id'].",%' OR addon_of LIKE '%,".$this->dataRecord['invoice_item_template_id']."' OR addon_of LIKE '%,".$this->dataRecord['invoice_item_template_id'].",%')");

				$addons_select = '';
				if(is_array($addons) && !empty($addons)){
					$i = 0;
					foreach($addons as $addon){
						$addons_select .= '<label for="addons'.$i.'" class="inlineLabel"><input name="addons[]" id="addons'.$i.'" value="'.$addon['invoice_item_template_id'].'" type="checkbox"> '.$addon['name'].'</label><br>';
						$i++;
					}
				}
				$app->tpl->setVar("addons", $addons_select);
				
				$updowngrades_select = '';
				$possible_updowngrades = $app->db->queryOneRecord("SELECT updowngradable_to FROM invoice_item_template WHERE invoice_item_template_id = ".$this->dataRecord['invoice_item_template_id']." AND updowngradable_to != ''");
				if(is_array($possible_updowngrades) && !empty($possible_updowngrades)){
					$possible_updowngrades = explode(',', $possible_updowngrades['updowngradable_to']);
					$i = 0;
					foreach($possible_updowngrades as $possible_updowngrade){
						$updowngrade = $app->db->queryOneRecord("SELECT * FROM invoice_item_template WHERE offer_in_shop = 'y' AND is_standalone = 'y' AND invoice_item_template_id = ".$possible_updowngrade);
						$updowngrades_select .= '<label for="updowngrades'.$i.'" class="inlineLabel"><input name="updowngrades[]" id="updowngrades'.$i.'" value="'.$updowngrade['invoice_item_template_id'].'" type="radio"> '.$updowngrade['name'].'</label><br>';
						$i++;
					}

					$app->tpl->setVar("updowngrades", $updowngrades_select);
				}

                // Template parsen
                $app->tpl->pparse();
	}

	function onUpdate() {
		global $app;
		// make sure users click on the submit button instead of changing tabs
		if($_POST['clickedsubmitbutton'] != 'yes'){
			unset($this->dataRecord);
			parent::onUpdate();
			return;
		}
		
		$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_dashboard_product.lng';
		if(is_file($lng_file)) include($lng_file);
		
		if(isset($_POST['end_date']) && $_POST['end_date'] != ''){
			// send email with old and new customer values to the company that belongs to the customer
			$email = $app->db->queryOneRecord("SELECT invoice_company.email, invoice_company.bcc_email FROM invoice_company, invoice_client_settings WHERE invoice_client_settings.client_id = ".$_SESSION['s']['user']['client_id']." AND invoice_client_settings.invoice_company_id = invoice_company.invoice_company_id");
		
			$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$_SESSION['s']['user']['client_id']);
		
			$product = $app->db->queryOneRecord("SELECT * FROM invoice_recurring_item WHERE invoice_recurring_item_id = ".$this->id);
		
			$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
			if(is_array($email) && !empty($email)){
				$email_subject = $app->tform->wordbook['subject_product_cancellation_txt'].': '.$product['name'];
			
			
				$tmp = explode('-',$product['next_payment_date']);
				$product['next_payment_date'] =	date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				$tmp = explode('-',$product['start_date']);
				$product['start_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				
                if(function_exists('date_parse_from_format')) {
                    $tmp = date_parse_from_format($app->lng('conf_format_dateshort'),$_POST['end_date']);
                    $tmp = mktime(0, 0, 0, $tmp['month'], $tmp['day'], $tmp['year']);
                } else {
                    $tmp = strtotime($_POST['end_date']);
                    if($tmp === false) $tmp = 0;
                }
                $product['end_date'] = date($app->lng('conf_format_dateshort'),$tmp);
				
				$email_msg = $app->tform->wordbook['body_product_cancellation_date_txt'].': '.date($app->lng('conf_format_dateshort').' '.$app->lng('conf_format_timelong')).'
			
'.$app->tform->wordbook['body_product_cancellation_the_customer_txt'].' 

'.$app->tform->wordbook['company_name_txt'].': '.$client['company_name'].'
'.$app->tform->wordbook['contact_name_txt'].': '.$client['contact_name'].'
'.$app->tform->wordbook['customer_no_txt'].': '.$client['customer_no'].'
'.$app->tform->wordbook['street_txt'].': '.$client['street'].'
'.$app->tform->wordbook['zip_txt'].': '.$client['zip'].'
'.$app->tform->wordbook['city_txt'].': '.$client['city'].'
'.$app->tform->wordbook['state_txt'].': '.$client['state'].'
'.$app->tform->wordbook['country_txt'].': '.$client['country'].'
'.$app->tform->wordbook['telephone_txt'].': '.$client['telephone'].'
'.$app->tform->wordbook['mobile_txt'].': '.$client['mobile'].'
'.$app->tform->wordbook['fax_txt'].': '.$client['fax'].'
'.$app->tform->wordbook['email_txt'].': '.$client['email'].'
'.$app->tform->wordbook['internet_txt'].': '.$client['internet'].'
'.$app->tform->wordbook['icq_txt'].': '.$client['icq'].'
'.$app->tform->wordbook['vat_id_txt'].': '.$client['vat_id'].'
'.$app->tform->wordbook['company_id_txt'].': '.$client['company_id'].'
'.$app->tform->wordbook['bank_account_owner_txt'].': '.$client['bank_account_owner'].'
'.$app->tform->wordbook['bank_account_number_txt'].': '.$client['bank_account_number'].'
'.$app->tform->wordbook['bank_code_txt'].': '.$client['bank_code'].'
'.$app->tform->wordbook['bank_name_txt'].': '.$client['bank_name'].'
'.$app->tform->wordbook['bank_account_iban_txt'].': '.$client['bank_account_iban'].'
'.$app->tform->wordbook['bank_account_swift_txt'].': '.$client['bank_account_swift'].'
'.$app->tform->wordbook['paypal_email_txt'].': '.$client['paypal_email'].'


'.$app->tform->wordbook['body_product_cancellation_has_cancelled_the_following_product_txt'].':

'.$app->tform->wordbook['name_txt'].': '.$product['name'].'
'.$app->tform->wordbook['quantity_txt'].': '.$product['quantity'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($product['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($product['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($product['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$product['recur_months'].' '.$app->tform->wordbook['months_txt'].'
'.$app->tform->wordbook['next_payment_date_txt'].': '.$product['next_payment_date'].'
'.$app->tform->wordbook['start_date_txt'].': '.$product['start_date'].'
'.$app->tform->wordbook['end_date_txt'].': '.$product['end_date'];

				$app->functions->mail(trim($email['email']), $email_subject, $email_msg, $client['email'], '', 'application/pdf', '', '', trim($email['bcc_email']), trim($client['contact_name']));
			}
		
			/*
			*  If there is a client-template, process it */
            $app->uses('client_templates');
            $app->client_templates->apply_client_templates($this->id);
		}
		
		if(is_array($_POST['addons']) && !empty($_POST['addons'])){
		
			// send email with old and new customer values to the company that belongs to the customer
			$email = $app->db->queryOneRecord("SELECT invoice_company.email, invoice_company.bcc_email FROM invoice_company, invoice_client_settings WHERE invoice_client_settings.client_id = ".$_SESSION['s']['user']['client_id']." AND invoice_client_settings.invoice_company_id = invoice_company.invoice_company_id");
		
			$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$_SESSION['s']['user']['client_id']);
		
			$product = $app->db->queryOneRecord("SELECT * FROM invoice_recurring_item WHERE invoice_recurring_item_id = ".$this->id);
		
			$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
			if(is_array($email) && !empty($email)){
				$email_subject = $app->tform->wordbook['subject_addons_order_txt'].': '.$product['name'];
			
			
				$tmp = explode('-',$product['next_payment_date']);
				$product['next_payment_date'] =	date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				$tmp = explode('-',$product['start_date']);
				$product['start_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				$tmp = explode('-',$product['end_date']);
				$product['end_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				
				$email_msg = $app->tform->wordbook['body_addons_order_txt'].'
			
'.$app->tform->wordbook['body_addons_order_the_customer_txt'].' 

'.$app->tform->wordbook['company_name_txt'].': '.$client['company_name'].'
'.$app->tform->wordbook['contact_name_txt'].': '.$client['contact_name'].'
'.$app->tform->wordbook['customer_no_txt'].': '.$client['customer_no'].'
'.$app->tform->wordbook['street_txt'].': '.$client['street'].'
'.$app->tform->wordbook['zip_txt'].': '.$client['zip'].'
'.$app->tform->wordbook['city_txt'].': '.$client['city'].'
'.$app->tform->wordbook['state_txt'].': '.$client['state'].'
'.$app->tform->wordbook['country_txt'].': '.$client['country'].'
'.$app->tform->wordbook['telephone_txt'].': '.$client['telephone'].'
'.$app->tform->wordbook['mobile_txt'].': '.$client['mobile'].'
'.$app->tform->wordbook['fax_txt'].': '.$client['fax'].'
'.$app->tform->wordbook['email_txt'].': '.$client['email'].'
'.$app->tform->wordbook['internet_txt'].': '.$client['internet'].'
'.$app->tform->wordbook['icq_txt'].': '.$client['icq'].'
'.$app->tform->wordbook['vat_id_txt'].': '.$client['vat_id'].'
'.$app->tform->wordbook['company_id_txt'].': '.$client['company_id'].'
'.$app->tform->wordbook['bank_account_owner_txt'].': '.$client['bank_account_owner'].'
'.$app->tform->wordbook['bank_account_number_txt'].': '.$client['bank_account_number'].'
'.$app->tform->wordbook['bank_code_txt'].': '.$client['bank_code'].'
'.$app->tform->wordbook['bank_name_txt'].': '.$client['bank_name'].'
'.$app->tform->wordbook['bank_account_iban_txt'].': '.$client['bank_account_iban'].'
'.$app->tform->wordbook['bank_account_swift_txt'].': '.$client['bank_account_swift'].'
'.$app->tform->wordbook['paypal_email_txt'].': '.$client['paypal_email'].'


'.$app->tform->wordbook['body_addons_order_has_ordered_addons_to_the_following_product_txt'].' 

'.$app->tform->wordbook['name_txt'].': '.$product['name'].'
'.$app->tform->wordbook['quantity_txt'].': '.$product['quantity'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($product['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($product['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($product['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$product['recur_months'].' '.$app->tform->wordbook['months_txt'].'
'.$app->tform->wordbook['next_payment_date_txt'].': '.$product['next_payment_date'].'
'.$app->tform->wordbook['start_date_txt'].': '.$product['start_date'].'


'.$app->tform->wordbook['body_addons_order_these_are_the_ordered_addons_txt'].' 

';

				foreach($_POST['addons'] as $addon_id){
					$addon = $app->db->queryOneRecord("SELECT * FROM invoice_item_template WHERE invoice_item_template_id = ".$addon_id." AND offer_in_shop = 'y' AND is_addon = 'y'");
					if(is_array($addon) && !empty($addon)){
						$email_msg .= $app->tform->wordbook['name_txt'].': '.$addon['name'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($addon['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($addon['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($addon['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$addon['recur_months'].' '.$app->tform->wordbook['months_txt'].'

';
					}
				}

				$app->functions->mail(trim($email['email']), $email_subject, $email_msg, $client['email'], '', 'application/pdf', '', '', trim($email['bcc_email']), trim($client['contact_name']));
			}
		
			/*
			*  If there is a client-template, process it */
            $app->uses('client_templates');
            $app->client_templates->apply_client_templates($this->id);
		}
		
		if(is_array($_POST['updowngrades']) && !empty($_POST['updowngrades'])){
		
			// send email with old and new customer values to the company that belongs to the customer
			$email = $app->db->queryOneRecord("SELECT invoice_company.email, invoice_company.bcc_email FROM invoice_company, invoice_client_settings WHERE invoice_client_settings.client_id = ".$_SESSION['s']['user']['client_id']." AND invoice_client_settings.invoice_company_id = invoice_company.invoice_company_id");
		
			$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$_SESSION['s']['user']['client_id']);
		
			$product = $app->db->queryOneRecord("SELECT * FROM invoice_recurring_item WHERE invoice_recurring_item_id = ".$this->id);
		
			$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
			if(is_array($email) && !empty($email)){
				$email_subject = $app->tform->wordbook['subject_updowngrades_order_txt'].': '.$product['name'];
			
			
				$tmp = explode('-',$product['next_payment_date']);
				$product['next_payment_date'] =	date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				$tmp = explode('-',$product['start_date']);
				$product['start_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				$tmp = explode('-',$product['end_date']);
				$product['end_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]));
				
				$email_msg = $app->tform->wordbook['body_updowngrades_order_txt'].'
			
'.$app->tform->wordbook['body_updowngrades_order_the_customer_txt'].' 

'.$app->tform->wordbook['company_name_txt'].': '.$client['company_name'].'
'.$app->tform->wordbook['contact_name_txt'].': '.$client['contact_name'].'
'.$app->tform->wordbook['customer_no_txt'].': '.$client['customer_no'].'
'.$app->tform->wordbook['street_txt'].': '.$client['street'].'
'.$app->tform->wordbook['zip_txt'].': '.$client['zip'].'
'.$app->tform->wordbook['city_txt'].': '.$client['city'].'
'.$app->tform->wordbook['state_txt'].': '.$client['state'].'
'.$app->tform->wordbook['country_txt'].': '.$client['country'].'
'.$app->tform->wordbook['telephone_txt'].': '.$client['telephone'].'
'.$app->tform->wordbook['mobile_txt'].': '.$client['mobile'].'
'.$app->tform->wordbook['fax_txt'].': '.$client['fax'].'
'.$app->tform->wordbook['email_txt'].': '.$client['email'].'
'.$app->tform->wordbook['internet_txt'].': '.$client['internet'].'
'.$app->tform->wordbook['icq_txt'].': '.$client['icq'].'
'.$app->tform->wordbook['vat_id_txt'].': '.$client['vat_id'].'
'.$app->tform->wordbook['company_id_txt'].': '.$client['company_id'].'
'.$app->tform->wordbook['bank_account_owner_txt'].': '.$client['bank_account_owner'].'
'.$app->tform->wordbook['bank_account_number_txt'].': '.$client['bank_account_number'].'
'.$app->tform->wordbook['bank_code_txt'].': '.$client['bank_code'].'
'.$app->tform->wordbook['bank_name_txt'].': '.$client['bank_name'].'
'.$app->tform->wordbook['bank_account_iban_txt'].': '.$client['bank_account_iban'].'
'.$app->tform->wordbook['bank_account_swift_txt'].': '.$client['bank_account_swift'].'
'.$app->tform->wordbook['paypal_email_txt'].': '.$client['paypal_email'].'


'.$app->tform->wordbook['body_updowngrades_order_has_ordered_an_updowngrade_for_the_following_product_txt'].' 

'.$app->tform->wordbook['name_txt'].': '.$product['name'].'
'.$app->tform->wordbook['quantity_txt'].': '.$product['quantity'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($product['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($product['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($product['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$product['recur_months'].' '.$app->tform->wordbook['months_txt'].'
'.$app->tform->wordbook['next_payment_date_txt'].': '.$product['next_payment_date'].'
'.$app->tform->wordbook['start_date_txt'].': '.$product['start_date'].'


'.$app->tform->wordbook['body_updowngrades_order_this_is_the_ordered_updowngrade_txt'].' 

';

				foreach($_POST['updowngrades'] as $updowngrade_id){
					$updowngrade = $app->db->queryOneRecord("SELECT * FROM invoice_item_template WHERE invoice_item_template_id = ".$updowngrade_id." AND offer_in_shop = 'y' AND is_standalone = 'y'");
					if(is_array($updowngrade) && !empty($updowngrade)){
						$email_msg .= $app->tform->wordbook['name_txt'].': '.$updowngrade['name'].'
'.$app->tform->wordbook['price_txt'].': '.$app->functions->currency_format($updowngrade['price'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['setup_fee_txt'].': '.$app->functions->currency_format($updowngrade['setup_fee'], 'client').' '.$invoice_settings['currency'].'
'.$app->tform->wordbook['vat_txt'].': '.$app->functions->currency_format($updowngrade['vat'], 'client').' %
'.$app->tform->wordbook['recur_months_txt'].': '.$updowngrade['recur_months'].' '.$app->tform->wordbook['months_txt'].'

';
					}
				}

				$app->functions->mail(trim($email['email']), $email_subject, $email_msg, $client['email'], '', 'application/pdf', '', '', trim($email['bcc_email']), trim($client['contact_name']));
			}
		
			/*
			*  If there is a client-template, process it */
            $app->uses('client_templates');
            $app->client_templates->apply_client_templates($this->id);
		}
		
		parent::onUpdate();
	}

}

$page = new page_action;
$page->onLoad();

?>
