<?php

/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).


*/

$form["title"] 			= "Product";
$form["description"] 	= "";
$form["name"] 			= "dashboard_product";
$form["action"]			= "../billing/dashboard_product_edit.php";
$form["db_table"]		= "invoice_recurring_item";
$form["db_table_idx"]	= "invoice_recurring_item_id";
$form["db_history"]		= "no";
$form["tab_default"]	= "product";
$form["list_default"]	= "../dashboard/dashboard.php";
$form["auth"]			= 'no';

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");

$form["tabs"]['product'] = array (
	'title' 	=> "Product Details",
	'width' 	=> 100,
	'template' 	=> "templates/dashboard_product.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
	##################################
	# END Datatable fields
	##################################
	)
);

$form["tabs"]['updowngrade'] = array (
	'title' 	=> "Up-/Downgrade",
	'width' 	=> 100,
	'template' 	=> "templates/dashboard_product_updowngrade.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
	##################################
	# ENDE Datatable fields
	##################################
	),
);

$form["tabs"]['addons'] = array (
	'title' 	=> "Addons",
	'width' 	=> 100,
	'template' 	=> "templates/dashboard_product_addons.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
	/*
		'addons' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOXARRAY',
			'default'	=> '',
			'separator' => ',',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT invoice_item_template_id,name FROM invoice_item_template WHERE offer_in_shop = 'y' AND is_addon = 'y' AND (addon_of = '{RECORDID}' OR addon_of LIKE '{RECORDID},%' OR addon_of LIKE '%,{RECORDID}' OR addon_of LIKE '%,{RECORDID},%') AND invoice_item_template_id != {RECORDID} ORDER BY name",
										'keyfield'=> 'invoice_item_template_id',
										'valuefield'=> 'name'
									 ),
			'value'		=> ''
		),
	*/
	##################################
	# ENDE Datatable fields
	##################################
	),
);

$form["tabs"]['cancellation'] = array (
	'title' 	=> "Cancellation",
	'width' 	=> 100,
	'template' 	=> "templates/dashboard_product_cancellation.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
		'end_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'SELECT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
	##################################
	# ENDE Datatable fields
	##################################
	),
);


?>