<?php

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).


*/

$form["title"] 			= "Invoice";
$form["description"] 	= "";
$form["name"] 			= "invoice";
$form["action"]			= "invoice_edit.php";
$form["db_table"]		= "invoice";
$form["db_table_idx"]	= "invoice_id";
$form["db_history"]		= "no";
$form["tab_default"]	= "address";
$form["list_default"]	= "invoice_list.php";
$form["auth"]			= 'yes';

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

//$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");

if(isset($_GET['invoice_type'])) {
	switch ($_GET['invoice_type']) {
		case 'refund':
			$invoice_type = 'refund';
			break;
		case 'proforma':
			$invoice_type = 'proforma';
			break;
		case 'reminder':
			$invoice_type = 'reminder';
			break;
		case 'invoice':
			$invoice_type = 'invoice';
			break;
		default:
			$invoice_type = 'invoice';
	}
} else {
	$invoice_type = 'invoice';
}


$form["tabs"]['address'] = array (
	'title' 	=> "Address",
	'width' 	=> 100,
	'template' 	=> "templates/invoice_edit_address.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
		'invoice_type' => array (
			'datatype'	=> 'VARCHAR',

			'formtype'	=> 'SELECT',
			'default'	=> $invoice_type,
			'value'		=> array('invoice' => 'Invoice', 'refund' => 'Refund', 'reminder' => 'Reminder', 'proforma' => 'Proforma')
		),
		'invoice_company_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT invoice_company_id,company_name FROM invoice_company ORDER BY company_name',
										'keyfield'=> 'invoice_company_id',
										'valuefield'=> 'company_name'
									 ),
			'value'		=> ''
		),
		'client_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT client_id,CONCAT(company_name,' :: ',contact_name) as name FROM client ORDER BY company_name,contact_name",
										'keyfield'=> 'client_id',
										'valuefield'=> 'name'
									 ),
			'value'		=> ''
		),
		'invoice_number' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'invoice_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'TEXT',
			'default'	=> date($app->lng('conf_format_dateshort')),
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
		'payment_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
		'company_name' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'contact_name' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'street' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'zip' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '10',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'city' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'state' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'country' => array (
			'datatype'	=> 'VARCHAR',

			'formtype'	=> 'SELECT',
			'default'	=> (isset($conf['language']) ? strtoupper($conf['language']) : 'DE'),
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT iso,printable_name FROM country ORDER BY printable_name',
										'keyfield'=> 'iso',
										'valuefield'=> 'printable_name'
									 ),
			'value'		=> ''
		),
		'email' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'vat_id' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'payment_terms' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT invoice_payment_term_id,name FROM invoice_payment_term ORDER BY name",
										'keyfield'=> 'invoice_payment_term_id',
										'valuefield'=> 'name'
									 ),
			'default'	=> '',
			'separator' => ',',
			'value'		=> ''
		),
		'payment_gateway' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'default'	=> '',
			'separator' => ',',
			'value'		=> array('none' => 'None','auto'=>'Auto')
		),
		'status_printed' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'status_sent' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'status_paid' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'status_reminded' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'status_refunded' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'invoice_amount' => array (
			'datatype'	=> 'CURRENCY',
			'formtype'	=> 'TEXT',
			'default'	=> '0,00',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '255'
		),
		'notes' => array (
			'datatype'	=> 'TEXT',
			'formtype'	=> 'TEXTAREA',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '',
			'maxlength'	=> '',
			'rows'		=> '10',
			'cols'		=> '30'
		),
		'annotation' => array (
			'datatype'	=> 'TEXT',
			'formtype'	=> 'TEXTAREA',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '',
			'maxlength'	=> '',
			'rows'		=> '10',
			'cols'		=> '30'
		),
	##################################
	# END Datatable fields
	##################################
	)
);


$form["tabs"]['invoice_items'] = array (
	'title' 	=> "Items",
	'width' 	=> 100,
	'template' 	=> "templates/invoice_edit_item.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
	##################################
	# ENDE Datatable fields
	##################################
	),
	'plugins' => array (
     	'invoice_item' => array (
         	'class'   => 'plugin_invoiceitem',
     		'options' => array()
        ),
		'invoice_item_list' => array (
         	'class'   => 'plugin_invoiceitemlist',
     		'options' => array()
        )
	)
);



?>