<?php

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).


*/

$form["title"] 			= "Invoice client settings";
$form["description"] 	= "";
$form["name"] 			= "invoice_client_settings";
$form["action"]			= "invoice_client_settings_edit.php";
$form["db_table"]		= "invoice_client_settings";
$form["db_table_idx"]	= "client_id";
$form["db_history"]		= "no";
$form["tab_default"]	= "settings";
$form["list_default"]	= "client_list.php";
$form["auth"]			= 'yes';

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

$form["tabs"]['settings'] = array (
	'title' 	=> "Settings",
	'width' 	=> 100,
	'template' 	=> "templates/invoice_client_settings.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
		'invoice_company_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT invoice_company_id,company_name FROM invoice_company ORDER BY company_name',
										'keyfield'=> 'invoice_company_id',
										'valuefield'=> 'company_name'
									 ),
			'value'		=> ''
		),
		'payment_email' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'payment_terms' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT invoice_payment_term_id,name FROM invoice_payment_term ORDER BY name",
										'keyfield'=> 'invoice_payment_term_id',
										'valuefield'=> 'name'
									 ),
			'default'	=> '',
			'separator' => ',',
			'value'		=> ''
		),
		'payment_gateway' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'default'	=> '',
			'separator' => ',',
			'value'		=> array('none' => 'None','auto'=>'Auto')
		),
		'no_invoice_sending' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'last_invoice_number' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '0',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'last_refund_number' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '0',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'last_proforma_number' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '0',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
	##################################
	# END Datatable fields
	##################################
	)
);



?>