<?php

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).


*/

$form["title"] 			= "Email message";
$form["description"] 	= "";
$form["name"] 			= "invoice_message";
$form["action"]			= "invoice_message_edit.php";
$form["db_table"]		= "invoice_message";
$form["db_table_idx"]	= "invoice_message_id";
$form["db_history"]		= "no";
$form["tab_default"]	= "message";
$form["list_default"]	= "invoice_message_list.php";
$form["auth"]			= 'yes';

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");

$form["tabs"]['message'] = array (
	'title' 	=> "Message",
	'width' 	=> 100,
	'template' 	=> "templates/invoice_message.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
		'invoice_company_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT invoice_company_id,company_name FROM invoice_company ORDER BY company_name',
										'keyfield'=> 'invoice_company_id',
										'valuefield'=> 'company_name'
									 ),
			'value'		=> ''
		),
		'client_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> @$_REQUEST['client_id'],
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT client_id,CONCAT(company_name,' :: ',contact_name,' (',email,')') as name FROM client ORDER BY company_name,contact_name",
										'keyfield'=> 'client_id',
										'valuefield'=> 'name'
									 ),
			'value'		=> ''
		),
		'message_template_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> @$_REQUEST['message_template_id'],
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT invoice_message_template_id,template_name FROM invoice_message_template ORDER BY template_name',
										'keyfield'=> 'invoice_message_template_id',
										'valuefield'=> 'template_name'
									 ),
			'value'		=> ''
		),
		'message_type' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'default'	=> '',
			'value'		=> array('invoice' => 'Invoice', 'refund' => 'Refund', 'reminder' => 'Reminder','other' => 'Other')
		),
		'subject' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'message' => array (
			'datatype'	=> 'TEXT',
			'formtype'	=> 'TEXTAREA',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'invoice_id' => array (
			'datatype'	=> 'INTEGER',
			'formtype'	=> 'TEXT',
			'default'	=> @$_REQUEST['invoice_id'],
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'message_sent_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'TEXT',
			'default'	=> date($app->lng('conf_format_dateshort')),
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
		'message_status' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> 'draft',
			'value'		=> ''
		),
	##################################
	# END Datatable fields
	##################################
	)
);



?>