<?php

/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).


*/

$form["title"] 			= "Recurring invoice item";
$form["description"] 	= "";
$form["name"] 			= "invoice_recurring_item";
$form["action"]			= "invoice_recurring_item_edit.php";
$form["db_table"]		= "invoice_recurring_item";
$form["db_table_idx"]	= "invoice_recurring_item_id";
$form["db_history"]		= "no";
$form["tab_default"]	= "item";
$form["list_default"]	= "invoice_recurring_item_list.php";
$form["auth"]			= 'yes';

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");

$form["tabs"]['item'] = array (
	'title' 	=> "Item",
	'width' 	=> 100,
	'template' 	=> "templates/invoice_recurring_item.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
		'invoice_company_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT invoice_company_id,company_name FROM invoice_company ORDER BY company_name',
										'keyfield'=> 'invoice_company_id',
										'valuefield'=> 'company_name'
									 ),
			'value'		=> ''
		),
		'client_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT client_id,CONCAT(company_name,' :: ',contact_name) as name FROM client ORDER BY company_name,contact_name",
										'keyfield'=> 'client_id',
										'valuefield'=> 'name'
									 ),
			'value'		=> array(0 => '- '.$app->lng('select client').' -')
		),
		'invoice_item_template_id' => array (
			'datatype'	=> 'INTEGER',

			'formtype'	=> 'SELECT',
			'default'	=> '0',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT invoice_item_template_id,name FROM invoice_item_template WHERE type = 'Recurring' ORDER BY name",
										'keyfield'=> 'invoice_item_template_id',
										'valuefield'=> 'name'
									 ),
			'value'		=> array(0 => '- '.$app->lng('no template').' -')
		),
		'type' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'default'	=> '',
			'separator' => ',',
			'value'		=> array('clienttemplate' => 'Client template', 'domain' => 'Domain','web' => 'Web','service' => 'Service','other' => 'Other')
		),
		'name' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'validators'	=> array ( 	0 => array (	'type'	=> 'NOTEMPTY',
														'errmsg'=> 'name_error_empty'),
										),
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'description' => array (
			'datatype'	=> 'TEXT',
			'formtype'	=> 'TEXTAREA',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '',
			'maxlength'	=> '',
			'rows'		=> '10',
			'cols'		=> '30'
		),
		'quantity' => array (
			'datatype'	=> 'INTEGER',
			'formtype'	=> 'TEXT',
			'default'	=> '1',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '3',
			'maxlength'	=> '3',
			'rows'		=> '',
			'cols'		=> ''
		),
		'price' => array (
			'datatype'	=> 'CURRENCY',
			'formtype'	=> 'TEXT',
			'validators'	=> array ( 	0 => array (	'type'	=> 'NOTEMPTY',
														'errmsg'=> 'price_error_empty'),
										),
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '10',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'setup_fee' => array (
			'datatype'	=> 'CURRENCY',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '10',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'vat' => array (
			'datatype'	=> 'CURRENCY',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '5',
			'maxlength'	=> '5',
			'rows'		=> '',
			'cols'		=> ''
		),
		'recur_months' => array (
			'datatype'	=> 'INTEGER',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '3',
			'maxlength'	=> '3',
			'rows'		=> '',
			'cols'		=> ''
		),
		'next_payment_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'TEXT',
			'default'	=> date($app->lng('conf_format_dateshort')),
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
		'advance_payment' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'y',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'start_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'TEXT',
			'default'	=> date($app->lng('conf_format_dateshort')),
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
		'end_date' => array (
			'datatype'	=> 'DATE',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '15',
			'maxlength'	=> '15',
			'rows'		=> '',
			'cols'		=> ''
		),
		'cancellation_period' => array (
			'datatype'	=> 'INTEGER',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '10',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'send_reminder' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'separator'	=> '',
			'width'		=> '30',
			'maxlength'	=> '255',
			'rows'		=> '',
			'cols'		=> ''
		),
		'active' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'y',
			'value'		=> array(0 => 'n',1 => 'y')
		),
	##################################
	# END Datatable fields
	##################################
	)
);


?>