<?php
/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/


/******************************************
* Begin Form configuration
******************************************/

$tform_def_file = "form/invoice_company.tform.php";

/******************************************
* End Form configuration
******************************************/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');

//* Check permissions for module
$app->auth->check_module_permissions('billing');

// Loading classes
$app->uses('tpl,tform,tform_actions');
$app->load('tform_actions');

class page_action extends tform_actions {
    function onShowEnd() {
        global $app;
        
        $invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
        $app->tpl->setVar('currency_txt',$invoice_settings['currency']);
        // Template parsen
        $app->tpl->pparse();
    }
	function onBeforeUpdate() {
		global $app;
		// do we use placeholders for invoice prefix, refund prefix, and proforma prefix? If so, we must make sure that {COUNTER} is included somewhere in the pattern
		$error = '';
		if(strpos($this->dataRecord['invoice_number_prefix'], '{') !== false){
			if(strpos($this->dataRecord['invoice_number_prefix'], '{COUNTER}') === false) $error .= $app->lng('error_invoice_number_prefix_no_counter_txt').'<br>';
		}
		if(strpos($this->dataRecord['refund_number_prefix'], '{') !== false){
			if(strpos($this->dataRecord['refund_number_prefix'], '{COUNTER}') === false) $error .= $app->lng('error_refund_number_prefix_no_counter_txt').'<br>';
		}
		if(strpos($this->dataRecord['proforma_number_prefix'], '{') !== false){
			if(strpos($this->dataRecord['proforma_number_prefix'], '{COUNTER}') === false) $error .= $app->lng('error_proforma_number_prefix_no_counter_txt');
		}
		
		if($error != '') $app->tform->errorMessage = $error;

		parent::onBeforeUpdate();
	}
	
}

$page = new page_action;
$page->onLoad();

?>