<?php
/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/


/******************************************
* Begin Form configuration
******************************************/

$tform_def_file = "form/invoice_recurring_item.tform.php";

/******************************************
* End Form configuration
******************************************/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');

//* Check permissions for module
$app->auth->check_module_permissions('billing');

// Loading classes
$app->uses('tpl,tform,tform_actions');
$app->load('tform_actions');

//$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
$app->tform->dateformat = $app->lng('conf_format_dateshort');

class page_action extends tform_actions {

	function onSubmit() {
		global $app;
		
		// If we load a template, we set a fake error message to make sure that the item does not get saved.
		if($_GET['action'] == 'loadtemplate') {
			$app->tform->errorMessage = 'nosave';
		}
		parent::onSubmit();
	}

	function onShowNew() {
		global $app;
		
		if($app->tform->errorMessage == '') {
			$record = array();
            $record = $app->tform->getHTML($record, $app->tform->formDef['tab_default'],'NEW');
			
		} else {
			$record = $app->tform->getHTML($app->tform->encode($_POST,$this->active_tab),$this->active_tab,'EDIT');
        }

        $app->tpl->setVar($record);	
	}

	
	function onShowEnd() {
                global $app, $conf;
				
				// If we load data from a template, we overwrite some variables and remove 
				// our fake error that was set in onSubmit event
				if(isset($_GET['action']) && $_GET['action'] == 'loadtemplate') {
					if($_POST['invoice_item_template_id'] > 0) {
						$tmp = $app->db->queryOneRecord("SELECT * FROM invoice_item_template WHERE invoice_item_template_id = ".intval($_POST['invoice_item_template_id']));
						$record['description'] = $tmp['description'];
						$record['price'] = $app->functions->currency_format($tmp['price']);
						$record['setup_fee'] = $app->functions->currency_format($tmp['setup_fee']);
						$record['vat'] = $tmp['vat'];
						$record['recur_months'] = $tmp['recur_months'];
						$record['cancellation_period'] = $tmp['cancellation_period'];
					} else {
						$record['description'] = '';
						$record['price'] = $app->functions->currency_format(0);
						$record['setup_fee'] = $app->functions->currency_format(0);
						$record['vat'] = '';
						$record['recur_months'] = 1;
						$record['cancellation_period'] = 30;
					}
					$record['error'] = '';
					$app->tpl->setVar($record);
				}
				
				$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
				$app->tpl->setVar('date_format_txt',$app->lng('conf_format_dateshort_human_readable'));
				$app->tpl->setVar('currency_txt',$invoice_settings['currency']);
				
				// Datepicker
				$date_format = $app->lng('conf_format_dateshort');
				$trans = array("d" => "dd", "m" => "mm", "Y" => "yy");
				$date_format = strtr($date_format, $trans);
				$app->tpl->setVar("date_format", $date_format);		
		
				$app->tpl->setVar("daynamesmin_su", $app->lng('daynamesmin_su'));
				$app->tpl->setVar("daynamesmin_mo", $app->lng('daynamesmin_mo'));
				$app->tpl->setVar("daynamesmin_tu", $app->lng('daynamesmin_tu'));
				$app->tpl->setVar("daynamesmin_we", $app->lng('daynamesmin_we'));
				$app->tpl->setVar("daynamesmin_th", $app->lng('daynamesmin_th'));
				$app->tpl->setVar("daynamesmin_fr", $app->lng('daynamesmin_fr'));
				$app->tpl->setVar("daynamesmin_sa", $app->lng('daynamesmin_sa'));
		
				$app->tpl->setVar("daynames_sunday", $app->lng('daynames_sunday'));
				$app->tpl->setVar("daynames_monday", $app->lng('daynames_monday'));
				$app->tpl->setVar("daynames_tuesday", $app->lng('daynames_tuesday'));
				$app->tpl->setVar("daynames_wednesday", $app->lng('daynames_wednesday'));
				$app->tpl->setVar("daynames_thursday", $app->lng('daynames_thursday'));
				$app->tpl->setVar("daynames_friday", $app->lng('daynames_friday'));
				$app->tpl->setVar("daynames_saturday", $app->lng('daynames_saturday'));
		
				$app->tpl->setVar("monthnamesshort_jan", $app->lng('monthnamesshort_jan'));
				$app->tpl->setVar("monthnamesshort_feb", $app->lng('monthnamesshort_feb'));
				$app->tpl->setVar("monthnamesshort_mar", $app->lng('monthnamesshort_mar'));
				$app->tpl->setVar("monthnamesshort_apr", $app->lng('monthnamesshort_apr'));
				$app->tpl->setVar("monthnamesshort_may", $app->lng('monthnamesshort_may'));
				$app->tpl->setVar("monthnamesshort_jun", $app->lng('monthnamesshort_jun'));
				$app->tpl->setVar("monthnamesshort_jul", $app->lng('monthnamesshort_jul'));
				$app->tpl->setVar("monthnamesshort_aug", $app->lng('monthnamesshort_aug'));
				$app->tpl->setVar("monthnamesshort_sep", $app->lng('monthnamesshort_sep'));
				$app->tpl->setVar("monthnamesshort_oct", $app->lng('monthnamesshort_oct'));
				$app->tpl->setVar("monthnamesshort_nov", $app->lng('monthnamesshort_nov'));
				$app->tpl->setVar("monthnamesshort_dec", $app->lng('monthnamesshort_dec'));		
		
				$app->tpl->setVar("datepicker_nextText", $app->lng('datepicker_nextText'));
				$app->tpl->setVar("datepicker_prevText", $app->lng('datepicker_prevText'));

                // Template parsen
                $app->tpl->pparse();
        }

}

$page = new page_action;
$page->onLoad();

?>