<?php

/*
Copyright (c) 2010, Till Brehm, projektfarm Gmbh
All rights reserved.
*/

/*
	Datatypes:
	- INTEGER
	- DOUBLE
	- CURRENCY
	- VARCHAR
	- TEXT
	- DATE
*/



// Name of the list
$liste["name"] 				= "invoice_draft";

// Database table
$liste["table"] 			= "invoice";

// Index index field of the database table
$liste["table_idx"]			= "invoice_id";

// Search Field Prefix
$liste["search_prefix"] 	= "search_";

// Records per page
$liste["records_per_page"] 	= 15;

// Script File of the list
$liste["file"]				= "invoice_draft_list.php";

// Script file of the edit form
$liste["edit_file"]			= "invoice_edit.php";

// Script File of the delete script
$liste["delete_file"]		= "invoice_draft_del.php";

// Paging Template
$liste["paging_tpl"]		= "templates/paging.tpl.htm";

// Enable authe
$liste["auth"]				= "yes";


/*****************************************************
* Suchfelder
*****************************************************/

$liste["item"][] = array(	'field'		=> "invoice_number",
							'datatype'	=> "VARCHAR",
							'formtype'	=> "TEXT",
							'op'		=> "like",
							'prefix'	=> "%",
							'suffix'	=> "%",
							'width'		=> "",
							'value'		=> "");

$liste["item"][] = array(	'field'		=> "invoice_date",
							'datatype'	=> "DATE",
							'formtype'	=> "TEXT",
							'op'		=> "like",
							'prefix'	=> "%",
							'suffix'	=> "%",
							'width'		=> "",
							'value'		=> "");

$liste["item"][] = array(	'field'		=> "client_id",
							'datatype'	=> "INTEGER",
							'formtype'	=> "SELECT",
							'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => "SELECT client_id,CONCAT(company_name,' :: ',contact_name) as name FROM client ORDER BY company_name,contact_name",
										'keyfield'=> 'client_id',
										'valuefield'=> 'name'
									 ),
							'op'		=> "=",
							'prefix'	=> "",
							'suffix'	=> "",
							'width'		=> "",
							'value'		=> "");

$liste["item"][] = array(	'field'		=> "invoice_amount",
							'datatype'	=> "CURRENCY",
							'formtype'	=> "TEXT",
							'op'		=> "like",
							'prefix'	=> "%",
							'suffix'	=> "%",
							'width'		=> "",
							'value'		=> "");

$liste["item"][] = array(	'field'		=> "status_sent",
							'datatype'	=> "VARCHAR",
							'formtype'	=> "SELECT",
							'op'		=> "=",
							'prefix'	=> "",
							'suffix'	=> "",
							'width'		=> "",
							'value'		=> array('n' => $app->lng('No'),'y' => $app->lng('Yes')));

$liste["item"][] = array(	'field'		=> "status_printed",
							'datatype'	=> "VARCHAR",
							'formtype'	=> "SELECT",
							'op'		=> "=",
							'prefix'	=> "",
							'suffix'	=> "",
							'width'		=> "",
							'value'		=> array('n' => $app->lng('No'),'y' => $app->lng('Yes')));

$liste["item"][] = array(	'field'		=> "status_paid",
							'datatype'	=> "VARCHAR",
							'formtype'	=> "SELECT",
							'op'		=> "=",
							'prefix'	=> "",
							'suffix'	=> "",
							'width'		=> "",
							'value'		=> array('n' => $app->lng('No'),'y' => $app->lng('Yes')));





?>