<?php

require_once('../../../lib/config.inc.php');
require_once('../../../lib/app.inc.php');

$app->uses('tpl');

$tpl = new tpl;
$tpl->newTemplate("../templates/payments_pay.htm");
$error = '';

# Check if payment method = auto

$idhash = $app->db->quote($_GET['id']);
$invoice = $app->db->queryOneRecord("SELECT * FROM invoice WHERE idhash = '$idhash'");

if(!is_array($invoice)) $error .= 'Invalid invoice ID<br />';
if($invoice['status_paid'] == 'y') $error .= 'This invoice has already been paid.<br />';
if($invoice['payment_gateway'] == 'none') $error .= 'Payment page has been disabled for this invoice.<br />';

if($error != '') die($error);

$company = $app->db->queryOneRecord("SELECT * FROM invoice_company WHERE invoice_company_id = ".$invoice['invoice_company_id']);
$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
$client = $app->db->queryOneRecord("SELECT * FROM client WHERE client_id = ".$invoice['client_id']);

$out = array();

$out['company_logo'] = '../lib/logo/'.$company['company_logo'];
$out['company_name'] = $company['company_name'];
$out['company_street'] = $company['street'];
$out['company_zip'] = $company['zip'];
$out['company_state'] = $company['state'];
$out['company_country'] = $company['country'];

$out['invoice_name'] = $invoice['company_name'];
$out['invoice_street'] = $invoice['street'];
$out['invoice_zip'] = $invoice['zip'];
$out['invoice_state'] = $invoice['state'];
$out['invoice_country'] = $invoice['country'];

$out['invoice_number'] = $invoice['invoice_number'];

$date_parts = explode('-',$invoice['invoice_date']);
$out['invoice_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $date_parts[1]  , $date_parts[2], $date_parts[0]));

$out['invoice_amount_formatted'] = $app->functions->currency_format($invoice['invoice_amount'], 'client').' '.$invoice_settings['currency'];
$out['invoice_amount'] = round($invoice['invoice_amount'],2);
$out['invoice_currency'] = $invoice_settings['currency'];
$out['invoice_idhash'] = $invoice['idhash'];

$out['paypal_business'] = $invoice_settings['paypal_business'];

/*
Test: 'https://www.sandbox.paypal.com/cgi-bin/webscr';
Real: 'https://www.paypal.com/cgi-bin/webscr';
*/
$out['paypal_url'] = $invoice_settings['paypal_url'];

$ispconfig_url = $app->functions->get_ispconfig_url();

$out['paypal_notify_url'] = $invoice_settings['paypal_ipn_url'];
$out['paypal_success_url'] = $ispconfig_url.'/billing/payments/success.php';
$out['paypal_cancel_url'] = $ispconfig_url.'/billing/payments/cancel.php';
$out['paypal_visible'] = ($invoice_settings['paypal_active'] == 'y')?1:0;

$tpl->setVar($out);

$wb = array();

if(isset($_SESSION['s']['language'])) {
	$language = $_SESSION['s']['language'];
} else {
	$language = $client['language'];
}

$lng_file = '../lib/lang/'.$language.'_payments_pay.lng';
if(is_file($lng_file)) include($lng_file);
$tpl->setVar($wb);



echo $tpl->grab();

?>

