<?php
/*
Copyright (c) 2012, Till Brehm, ISPConfig UG
All rights reserved.
*/

require_once('../../lib/config.inc.php');
require_once('../../lib/app.inc.php');

//* Check permissions for module
$app->auth->check_module_permissions('billing');

//* This function is not available in demo mode
if($conf['demo_mode'] == true) $app->error('This function is disabled in demo mode.');

$app->uses('tpl,tform');

$app->tpl->newTemplate('form.tpl.htm');
$app->tpl->setInclude('content_tpl', 'templates/reset_invoice_counters.htm');

//* load language file 
$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_reset_invoice_counters.lng';
include($lng_file);
$app->tpl->setVar($wb);

$msg = '';
$error = '';

//* Save data
if(isset($_POST) && count($_POST) > 0) {
	$sql_queries = array();
	$invoice_company_id = intval($_POST['invoice_company']);
	if($invoice_company_id > 0){
		$where = " WHERE invoice_company_id = ".$invoice_company_id;
	} else {
		$where = "";
	}
	
	if(isset($_POST['reset_company_invoice_counter']) && $_POST['reset_company_invoice_counter'] == 1) {
		$sql_queries[] = "UPDATE invoice_company SET last_invoice_number = 0".$where;
	}
	if(isset($_POST['reset_company_refund_counter']) && $_POST['reset_company_refund_counter'] == 1) {
		$sql_queries[] = "UPDATE invoice_company SET last_refund_number = 0".$where;
	}
	if(isset($_POST['reset_company_proforma_counter']) && $_POST['reset_company_proforma_counter'] == 1) {
		$sql_queries[] = "UPDATE invoice_company SET last_proforma_number = 0".$where;
	}
	if(isset($_POST['reset_client_invoice_counter']) && $_POST['reset_client_invoice_counter'] == 1) {
		$sql_queries[] = "UPDATE invoice_client_settings SET last_invoice_number = 0".$where;
	}
	if(isset($_POST['reset_client_refund_counter']) && $_POST['reset_client_refund_counter'] == 1) {
		$sql_queries[] = "UPDATE invoice_client_settings SET last_refund_number = 0".$where;
	}
	if(isset($_POST['reset_client_proforma_counter_txt']) && $_POST['reset_client_proforma_counter_txt'] == 1) {
		$sql_queries[] = "UPDATE invoice_client_settings SET last_proforma_number = 0".$where;
	}
	
	if(!empty($sql_queries)){
		foreach($sql_queries as $sql_query){
			$app->db->query($sql_query);
		}
		$msg = ($wb['counters_successfully_reset_txt']? $wb['counters_successfully_reset_txt'] : 'Success');
	} else {
		$error = ($wb['error_select_counter_to_reset_txt']? $wb['error_select_counter_to_reset_txt'] : 'Error');
	}
}

// Invoice Company Drop-Down
$invoice_company = '<option value="0"'.(intval($_POST['invoice_company']) == 0 ? ' selected="selected"' : '').'>'.$wb['all_companies_txt'].'</option>';
$sql = "SELECT * FROM invoice_company WHERE ".$app->tform->getAuthSQL('r')." ORDER BY invoice_company_id ASC";
$companies = $app->db->queryAllRecords($sql);
if(is_array($companies) && !empty($companies)){
	foreach($companies as $company){
		$invoice_company .= '<option value="'.$company['invoice_company_id'].'"'.(intval($_POST['invoice_company']) == $company['invoice_company_id'] ? ' selected="selected"' : '').'>'.$company['invoice_company_id'].' :: '.$company['company_name'].'</option>';
	}
}
$app->tpl->setVar('invoice_company',$invoice_company);

$app->tpl->setVar('okmsg',$msg);
$app->tpl->setVar('error',$error);

$app->tpl_defaults();
$app->tpl->pparse();


?>
