<?php

class dashlet_products {
	
	function show() {
		global $app, $conf;
		
		//* Loading Template
		$app->uses('tpl');
		
		$tpl = new tpl;
		$tpl->newTemplate("dashlets/templates/products.htm");
		
		$wb = array();
		$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_dashlet_products.lng';
		if(is_file($lng_file)) include($lng_file);
		$lng_file = '../billing/lib/lang/'.$_SESSION['s']['language'].'_dashboard_client.lng';
		if(is_file($lng_file)) include($lng_file);
		$tpl->setVar($wb);
		
		$group_rec = $app->db->queryOneRecord('SELECT client_id FROM sys_group WHERE groupid = '.$_SESSION['s']['user']['default_group']);
		$client_id = $group_rec['client_id'];
		$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
		if($client_id > 0) {
			$tmps = $app->db->queryAllRecords("SELECT * FROM invoice_recurring_item WHERE client_id = $client_id");
			$products = array();
			if(is_array($tmps) && !empty($tmps)) {
				foreach($tmps as $tmp) {
					// show prices with VAT included
					$tmp['price'] = $tmp['price'] * ($tmp['vat']/100 + 1);
					$tmp['price'] = $app->functions->currency_format($tmp['price'], 'client');
					
					$date_parts = explode('-',$tmp['invoice_date']);
					
					$date_parts = explode('-',$tmp['next_payment_date']);
					$tmp['next_payment_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $date_parts[1]  , $date_parts[2], $date_parts[0]));
					$tmp['currency'] = $invoice_settings['currency'];
					
                    $date_parts = explode('-',$tmp['end_date']);
					$tmp['cancellation_date'] = date($app->lng('conf_format_dateshort'),mktime(0, 0, 0, $date_parts[1]  , $date_parts[2], $date_parts[0]));
					
					$products[] = $tmp;
				}
			}
			
			
			$tpl->setloop('products', $products);
			
			if(count($products) > 0) $has_products = true;
		}
		
		$tpl->setVar('has_products',$has_products);
		
		if($app->auth->is_admin()) {
			return '';
		} else {
			return $tpl->grab();
		}
		
		
	}
}








?>