<?php

class dashlet_shop {
	
	function show() {
		global $app, $conf;
		
		//* Loading Template
		$app->uses('tpl');
		
		$tpl = new tpl;
		$tpl->newTemplate("dashlets/templates/shop.htm");
		
		$wb = array();
		$lng_file = 'lib/lang/'.$_SESSION['s']['language'].'_dashlet_shop.lng';
		if(is_file($lng_file)) include($lng_file);
		$lng_file = '../billing/lib/lang/'.$_SESSION['s']['language'].'_dashboard_client.lng';
		if(is_file($lng_file)) include($lng_file);
		$tpl->setVar($wb);
		
		$group_rec = $app->db->queryOneRecord('SELECT client_id FROM sys_group WHERE groupid = '.$_SESSION['s']['user']['default_group']);
		$client_id = $group_rec['client_id'];
		$invoice_settings = $app->db->queryOneRecord("SELECT * FROM invoice_settings WHERE invoice_settings_id = 1");
		
		if($client_id > 0) {
			$tmps = $app->db->queryAllRecords("SELECT * FROM invoice_item_template WHERE offer_in_shop = 'y' AND is_standalone = 'y'");
			$products = array();
			if(is_array($tmps) && !empty($tmps)) {
				foreach($tmps as $tmp) {
					// show prices with VAT included
					$tmp['price'] = $tmp['price'] * ($tmp['vat']/100 + 1);
					$tmp['price'] = $app->functions->currency_format($tmp['price'], 'client');
					
					$tmp['setup_fee'] = $tmp['setup_fee'] * ($tmp['vat']/100 + 1);
					$tmp['setup_fee'] = $app->functions->currency_format($tmp['setup_fee'], 'client');
					$tmp['currency'] = $invoice_settings['currency'];
					
					$products[] = $tmp;
				}
			}
			
			
			$tpl->setloop('products', $products);
			
			if(count($products) > 0) $has_products = true;
		}
		
		$tpl->setVar('has_products',$has_products);
		
		if($app->auth->is_admin()) {
			return '';
		} else {
			return $tpl->grab();
		}
		
		
	}
}








?>