<?php
/**
 * @version		$Id: default.php 20196 2011-01-09 02:40:25Z ian $
 * @package		Joomla.Site
 * @subpackage	mod_menu
 * @copyright	Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

// Note. It is important to remove spaces between elements.

//Submenu Feature
$app 		= JFactory::getApplication();
$template 	= $app->getTemplate();
include_once( JPATH_SITE.DS.'templates'.DS.$template.DS.'helpers'.DS.'extension.php' );
$tmplComponent = PhocaTemplateExtension::getExtensionInfo('com_phocatemplate');
if ($tmplComponent == 1) {
	include_once( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_phocatemplate'.DS.'helpers'.DS.'phocatemplate.php' );
}
$showAllChildren 	= $params->get('showAllChildren', 0);
$positionSlideName	= 'phocaTopMenu';
//$positionSlideId	= 'position-1';

$slide = false;
if (isset($attribs['style']) && $attribs['style'] == $positionSlideName) {
//if (isset($attribs['name']) && $attribs['name'] == $positionSlideId) {
	$slide = true;
}
?>

<ul class="menu<?php echo $class_sfx;?>"<?php
	$tag = '';
	if(isset($attribs['style']) && $attribs['style'] == $positionSlideName) {
		$tag = 'ptm-nav';
	}
	
	if ($params->get('tag_id')!=NULL) {
		$tag = $params->get('tag_id').'';
	}
	if ($tag != '') {
		echo ' id="'.$tag.'"';
	}
?>>
<?php

if (!$slide) {
// ====================
// Render standard menu
// ====================
	foreach ($list as $i => &$item) :
		$class = '';
		if ($item->id == $active_id) {
			$class .= 'current ';
		}

		if (in_array($item->id, $path)) {
			$class .= 'active ';
		}

		if ($item->deeper) {
			$class .= 'parent ';
		}

		if (!empty($class)) {
			$class = ' class="'.trim($class) .'"';
		}

		echo '<li id="item-'.$item->id.'"'.$class.'>';

		// Render the menu item.
		switch ($item->type) :
			case 'separator':
			case 'url':
			case 'component':
				require JModuleHelper::getLayoutPath('mod_menu', 'default_'.$item->type);
				break;

			default:
				require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
				break;
		endswitch;

		// The next item is deeper.
		if ($item->deeper) {
			echo '<ul>';
		}
		// The next item is shallower.
		else if ($item->shallower) {
			echo '</li>';
			echo str_repeat('</ul></li>', $item->level_diff);
		}
		// The next item is on the same level.
		else {
			echo '</li>';
		}
	endforeach;


} else {
// ====================
// Render slide menu with custom submenu content
// ====================

	// DEFINITION = = = = = = = = = = 

	// SUBMENU-CONTENT - is the content (html content, module content, position content)
	//                   pasted into submenu tree on level2
	// MENU-ITEMS      - all menu items
	// MENU-GROUPS     - group begin with level1 and ends with level1 of next menu item, group = column
	// END DEFINITION = = = = = = = = 

	$m = array();	// Array for MENU-ITEMS  (menus - submenus)
	$h = array();	// Help array for MENU-GROUPS (store info which will be used for afterwards changes)
	$c = 0;			// Counter for MENU-GROUPS: i ... every menu item, c ... every menu group
	$rS = '%|pmr|%';// Replace String (temporary string to replace info there)

	foreach ($list as $i => &$item) {
		
		$class = '';
		if ($item->id == $active_id) {
			$class .= 'current ';
		}

		if (in_array($item->id, $path)) {
			$class .= 'active ';
		}

		if ($item->deeper) {
			$class .= 'parent ';
		}

		if (!empty($class)) {
			$class = ' class="'.trim($class) .'"';
		}
		
		
		// Here we define submenu if exists, we define it in parent level
		// and waiting for the next round of foreach to paste it into the submenu
		// Submenu is defined for every new level 1
		if ($item->level == 1) {
			$c++;
			$h[$c]['submenu'] = 0;
		}
		
		if ($item->level == 1) {
			if ($tmplComponent == 1 && $showAllChildren == 1) {
				$customSubmenuArray = PhocaTemplateHelper::getSubmenuOutput($item->id);
				if (isset($customSubmenuArray['o']) && $customSubmenuArray['o'] != '') {
					// Can by stylized here:
					// A) Above SUBMENU-CONTENT is a menu with slide effect submenus
					//    customsubmenulink is used in javascript to hide opened slide effect submenus
					$h[$c]['submenuL'] = '<div class="customsubmenulink" style="position:relative;width:auto;height:auto;">'.$customSubmenuArray['o'].'</div><div style="clear:both"></div>';
					
					// B) Above SUBMENU-CONTENT is a menu but no submenus with slide effect submenus
					//    customsubmenunolink is NOT used in javascript to hide opened slide effect submenus because they don't exist
					$h[$c]['submenuLN'] = '<div class="customsubmenunolink" style="position:relative;width:auto;height:auto;">'.$customSubmenuArray['o'].'</div><div style="clear:both"></div>';
					
					// C) Above SUBMENU-CONTENT there is nothing, only main menu link in level1
					//    customsubmenunolink is NOT used in javascript to hide opened slide effect submenus because they don't exist
					$h[$c]['submenuN'] = '<ul><li id="item-'.$item->id.'s">'
					.'<a style="display:none" href="#" ></a>'
					.'<div class="customsubmenunolink" style="position:relative;width:auto;height:auto;">'.$customSubmenuArray['o']
					.'</div><div style="clear:both"></div>'
					.'</li></ul>';
					$h[$c]['submenu'] = 1;	
				}
				
			}
		}
		$m[$c][$i]['level'] = $item->level;
		$m[$c][$i]['o']  	= '';
		
			// Width Level 1
		if (isset($customSubmenuArray['width']) && (int)$customSubmenuArray['width'] > 0 && $item->level == 1) {
			$m[$c][$i]['o'] .= '<li id="item-'.$item->id.'"'.$class.' style="width:'.(int)$customSubmenuArray['width'].'px" >';
		} else {
			$m[$c][$i]['o'] .= '<li id="item-'.$item->id.'"'.$class.'>';
		}
		
		// Need class for the javascript - menumatic, identify the link as really menu link 
		//if ($item->anchor_css == '') {
		$item->anchor_css = 'topmenulink';
		//}
			
		// Render the menu item.
		switch ($item->type) :
			case 'separator':
			case 'url':
			case 'component':
				ob_start();
				require JModuleHelper::getLayoutPath('mod_menu', 'default_'.$item->type);
				$urlContent = ob_get_clean();
				$m[$c][$i]['o'] .= str_replace ('<img src', '<img class="topmenuimglink" src', $urlContent);
				break;

			default:
				ob_start();
				require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
				$urlContent = ob_get_clean();
				$m[$c][$i]['o'] .= str_replace ('<img src', '<img class="topmenuimglink" src', $urlContent);
				break;
		endswitch;
		
		// Description Level 1
		if (isset($customSubmenuArray['desc']) && $customSubmenuArray['desc'] != '' && $item->level == 1) {
			$m[$c][$i]['o'] .= '<div class="tompmenumaindesc">'.$customSubmenuArray['desc'].'</div>';
		}
		
		// Prepare possible custom menu, add only sign which will be replaced at the end
		if (isset($h[$c]['submenu']) && $h[$c]['submenu'] == 1 && $item->level == 1) {
			$m[$c][$i]['o'] .= $rS;
		}
		// Prepare possible custom menu, add only sign which will be replaced at the end
		if (isset($h[$c]['submenu']) && $h[$c]['submenu'] == 1 && $item->level == 2) {
			$m[$c][$i]['o'] .= $rS;
		}

		
		// The next item is deeper.
		if ($item->deeper) {
			if ($item->level == 2) {
				// There should be display the submenu content
				// But we don't know if this is the last menu item with level2
				// we must wait until all sub sub ... menus are rendered and if they tell us
				// if this is last menu item in level2 or not, if yes, then
				// the wait temporary string will be changed to submenu content.
				$h[$c]['wait'] = $i;
				$h[$c]['deep'] = 1;
			}
			
			$m[$c][$i]['o'] .= '<ul>';
		}
		// The next item is shallower.
		else if ($item->shallower) {

			// Shallower means end of the menu group
			// The end can be in level2 but it can be in some deeper level
			// If the end is in level2, great we can add submenu cotent
			// But if the end is in deeper sub sub ... menu we need to add info to parent
			// It can happen:
			// 1) only level2 which ends - endstd will be set (ID of level2)
			// 2) only levelx (sublevel of level2) - endwait will be set (ID of level2 thanks to wait variable)
			// 3) both ends - level2 and levelx - then we need to decided below which end is "higher" and has priority
			
			if (isset($h[$c]['submenu']) && $h[$c]['submenu'] == 1 && $item->level == 2) {
				$h[$c]['endstd'] = $i;
			}
			if (isset($h[$c]['wait'])) {
				$h[$c]['endwait'] = $h[$c]['wait'];
			}
			
			$m[$c][$i]['o'] .= '</li>';
			$m[$c][$i]['o'] .= str_repeat('</ul></li>', $item->level_diff);
		}
		// The next item is on the same level.
		// 4) no level - add end if there is no level for the menu group
		else {

			if (isset($h[$c]['submenu']) && $h[$c]['submenu'] == 1 && $item->level == 1 && isset($h[$c]['submenuN'])) {
				// seems there is only submenu content, no menu links
				$m[$c][$i]['o'] .= $h[$c]['submenuN'];
				$m[$c][$i]['o'] .= '</li>';
			} else {
				$m[$c][$i]['o'] .= '</li>';
			}
		}
		$i++;
	}

	foreach ($m as $k => $v) {
		// There can be possible ends, set the one with higher priority (the latest menu as submenu is displayed at bottom)
		$end  = 0;
		if(isset($h[$k]['submenu']) && $h[$k]['submenu'] == 1) {
			$endW = 0;
			$endS = 0;
			if(isset($h[$k]['endwait']) && (int)$h[$k]['endwait'] > 0) {
				$endW = (int)$h[$k]['endwait'];
			}
			if(isset($h[$k]['endstd']) && (int)$h[$k]['endstd'] > 0) {
				$endS = (int)$h[$k]['endstd'];
			}
			$end = max((int)$endW, (int)$endS);
		}
		
		foreach ($v as $k2 => $v2) {
			// Replace the priority end (if there is level2)
			if ((int)$end > 0 && $end == $k2 && $v2['level'] == 2) {
				if (isset($h[$k]['submenuL']) && isset($h[$k]['deep']) && $h[$k]['deep'] == 1) {
					$v2['o'] = str_replace($rS, $h[$k]['submenuL'], $v2['o']);// possible opened slide sub sub menus should be closed (menu js)
				} else if (isset($h[$k]['submenuLN'])) {
					$v2['o'] = str_replace($rS, $h[$k]['submenuLN'], $v2['o']);// no possible opened slide sub sub menus (menu js)
				}
			}
			echo str_replace ($rS, '', $v2['o']);
		}
	}
	//krumo($m);
	//krumo($h); 
}
?>
</ul>