CREATE TABLE `shippingmethods` (`id` int(11) NOT NULL AUTO_INCREMENT,  `name` VARCHAR(128) NOT NULL,  `inactive` tinyint(4) DEFAULT 0,  `priority` int(11) DEFAULT 0,  `canestimate` tinyint(4) DEFAULT 0,  `estimationscript` VARCHAR(128),  `createdby` INTEGER UNSIGNED,  `creationdate` DATETIME,  `modifiedby` INTEGER UNSIGNED,  `modifieddate` TIMESTAMP, PRIMARY KEY(`id`));
ALTER TABLE `invoices` ADD COLUMN `shippingmethodid` INTEGER UNSIGNED AFTER `shippingmethod`;
UPDATE `invoices` SET shippingmethodid=0;
ALTER TABLE `invoices` ADD COLUMN `paymentmethodid` INTEGER UNSIGNED AFTER `paymentmethod`;
UPDATE `invoices` SET paymentmethodid=0;
ALTER TABLE `invoices` ADD COLUMN `routingnumber` INTEGER UNSIGNED AFTER `paymentmethodid`;
ALTER TABLE `invoices` ADD COLUMN `accountnumber` INTEGER UNSIGNED AFTER `routingnumber`;
ALTER TABLE `invoices` ADD COLUMN `transactionid` VARCHAR(64) AFTER `accountnumber`;
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (300,'Shipping Methods','table',2,'shippingmethods','shippingmethods','modules/bms/shippingmethods_addedit.php',30,'modules/bms/shippingmethods_addedit.php',30,30,30,-100,'inactivate','shippingmethods.inactive!=0','shippingmethods.priority, shippingmethods.name','','','',1,NOW(),1,NOW());
INSERT INTO `menu` (`name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES ('Shipping Methods','search.php?id=300',6,30,1,1,NOW(),NOW(),30);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (300,'All Records','shippingmethods.id!=-1',2,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (300,'Active Records','shippingmethods.inactive=0',0,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (300,'Inactive Records','shippingmethods.inactive=1',1,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (300,'new','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (300,'select','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (300,'edit','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (300,'printex','0',0,0);
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (300,'shippingmethods.name','name',0,'field');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`,`wrap`, `size`, `format`) VALUES (300,'name','shippingmethods.name','left','',1,'',0,'99%',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`,`wrap`, `size`, `format`) VALUES (300,'estimate','shippingmethods.canestimate','center','',2,'',0,'','boolean');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`,`wrap`, `size`, `format`) VALUES (300,'priority','shippingmethods.priority','right','',0,'',0,'',NULL);
CREATE TABLE `paymentmethods` (`id` int(11) NOT NULL AUTO_INCREMENT, `name` varchar(128) NOT NULL default '',  `type` enum('draft','charge','receivable') default NULL,  `priority` int(8) NOT NULL default '0',  `inactive` tinyint(1) NOT NULL default '0',  `onlineprocess` tinyint(1) NOT NULL default '0',  `processscript` varchar(128) default '',  `createdby` int(11) default NULL,  `creationdate` datetime default NULL,  `modifiedby` int(11) default NULL,  `modifieddate` TIMESTAMP,  PRIMARY KEY  (`id`));
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (301,'Payment Methods','table',2,'paymentmethods','paymentmethods','modules/bms/paymentmethods_addedit.php',30,'modules/bms/paymentmethods_addedit.php',30,30,30,-100,'inactivate','paymentmethods.inactive=0','paymentmethods.priority,paymentmethods.name','','','',1,NOW(),1,NOW());
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (301,'All Records','paymentmethods.id!=-1',2,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (301,'Active','paymentmethods.inactive=0',0,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (301,'Inactive','paymentmethods.inactive=1',1,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (301,'new','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (301,'select','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (301,'edit','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (301,'printex','1',0,0);
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (301,'paymentmethods.name','name',0,'field');
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (301,'name','paymentmethods.name','left','',1,'',0,'99%',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (301,'type','paymentmethods.type','left','',2,'',0,'',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (301,'id','paymentmethods.id','center','',0,'',0,'',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (301,'priority','paymentmethods.priority','center','',3,'',0,'',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (301,'online process','paymentmethods.onlineprocess','center','',4,'',0,'','boolean');
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES (214,'Payment Methods','search.php?id=301',6,40,1,1,NOW(),NOW(),30);
ALTER TABLE `clients` ADD COLUMN `shippingmethodid` INTEGER UNSIGNED DEFAULT 0;
ALTER TABLE `clients` ADD COLUMN `paymentmethodid` INTEGER UNSIGNED DEFAULT 0;
ALTER TABLE `clients` ADD COLUMN `discountid` INTEGER UNSIGNED DEFAULT 0;
ALTER TABLE `clients` DROP `paymentmethod`;
ALTER TABLE `clients` DROP `ccnumber`;
ALTER TABLE `clients` DROP `ccexpiration`;
ALTER TABLE `clients` DROP `displayname`
ALTER TABLE `clients` CHANGE COLUMN `state` `state` varchar(5) default NULL;
ALTER TABLE `clients` CHANGE COLUMN `shiptostate` `shiptostate` varchar(5) default NULL;
ALTER TABLE `invoices` CHANGE COLUMN `state` `state` varchar(5) default NULL;
CREATE TABLE `invoicestatuses` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,`name` VARCHAR(128), `invoicedefault` TINYINT UNSIGNED NOT NULL DEFAULT 0,`defaultassignedtoid` INTEGER UNSIGNED,`inactive` TINYINT UNSIGNED NOT NULL DEFAULT 0, `priority` INTEGER UNSIGNED NOT NULL DEFAULT 0, `createdby` INTEGER UNSIGNED, `creationdate` DATETIME, `modifiedby` INTEGER UNSIGNED, `modifieddate` TIMESTAMP, PRIMARY KEY(`id`));
CREATE TABLE `invoicestatushistory` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `invoiceid` INTEGER UNSIGNED, `invoicestatusid` INTEGER UNSIGNED, `statusdate` DATE, `assignedtoid` INTEGER UNSIGNED, PRIMARY KEY(`id`));
INSERT INTO `invoicestatuses` (`id`, `name`, `invoicedefault`, `defaultassignedtoid`, `inactive`, `priority`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (1,'Open',1,NULL,0,0,1,NOW(),1,NOW());
INSERT INTO `invoicestatuses` (`id`, `name`, `invoicedefault`, `defaultassignedtoid`, `inactive`, `priority`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (2,'Committed',0,NULL,0,10,1,NOW(),1,NOW());
INSERT INTO `invoicestatuses` (`id`, `name`, `invoicedefault`, `defaultassignedtoid`, `inactive`, `priority`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (3,'Packed',0,NULL,0,20,1,NOW(),1,NOW());
INSERT INTO `invoicestatuses` (`id`, `name`, `invoicedefault`, `defaultassignedtoid`, `inactive`, `priority`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (4,'Shipped / Ready To Invoice',0,NULL,0,30,1,NOW(),1,NOW());
INSERT INTO `tabledefs` (`id`, `displayname`, `type`, `moduleid`, `maintable`, `querytable`, `editfile`, `editroleid`, `addfile`, `addroleid`, `searchroleid`, `advsearchroleid`, `viewsqlroleid`, `deletebutton`, `defaultwhereclause`, `defaultsortorder`, `defaultsearchtype`, `defaultcriteriafindoptions`, `defaultcriteriaselection`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (302,'Invoice Statuses','table',2,'invoicestatuses','invoicestatuses','modules/bms/invoicestatuses_addedit.php',30,'modules/bms/invoicestatuses_addedit.php',30,30,-100,-100,'inactivate','invoicestatuses.inactive=0','invoicestatuses.priority,invoicestatuses.name','','','',1,NOW(),1,NOW());
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES (215,'----','',6,15,1,1,NOW(),NOW(),30);
INSERT INTO `menu` (`id`, `name`, `link`, `parentid`, `displayorder`, `createdby`, `modifiedby`, `creationdate`, `modifieddate`, `roleid`) VALUES (216,'invoice statuses','search.php?id=302',6,50,1,1,NOW(),NOW(),30);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (302,'name','invoicestatuses.name','left','',0,'',1,'99%',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (302,'priority','invoicestatuses.priority','right','',1,'',0,'',NULL);
INSERT INTO `tablecolumns` (`tabledefid`, `name`, `column`, `align`, `footerquery`, `displayorder`, `sortorder`, `wrap`, `size`, `format`) VALUES (302,'inactive','invoicestatuses.inactive','center','',2,'',0,'','boolean');
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (302,'Active Records','invoicestatuses.inactive=0',0,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (302,'All Records','invoicestatuses.id!=-1',1,0);
INSERT INTO `tablesearchablefields` (`tabledefid`, `field`, `name`, `displayorder`, `type`) VALUES (302,'invoicestatuses.name','name',0,'field');
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (302,'new','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (302,'select','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (302,'edit','1',0,0);
INSERT INTO `tableoptions` (`tabledefid`, `name`, `option`, `othercommand`, `roleid`) VALUES (302,'printex','0',0,0);
ALTER TABLE `invoices` CHANGE COLUMN `shippeddate` `statusdate` DATE DEFAULT NULL;
ALTER TABLE `invoices` ADD COLUMN `statusid` INTEGER UNSIGNED AFTER `status`;
ALTER TABLE `invoices` ADD COLUMN `assignedtoid` INTEGER UNSIGNED AFTER `statusid`;
UPDATE `tabledefs` SET `querytable`='((invoices inner join clients on invoices.clientid=clients.id) inner join invoicestatuses on invoices.statusid=invoicestatuses.id)' WHERE `id` =3;
UPDATE `tablecolumns` SET `column`='invoicestatuses.name' WHERE `column`='invoices.status';
UPDATE `tablefindoptions` SET `search`='invoices.type=\"Order\" and invoicestatuses.name=\"Shipped / Ready To Invoice\"' WHERE `id`=24;
UPDATE `tablefindoptions` SET `search`='invoices.type=\"Order\" and invoicestatuses.name=\"Packed\"' WHERE `id`=23;
UPDATE `tablefindoptions` SET `search`='invoices.type=\"Order\" and invoicestatuses.name=\"Committed\"' WHERE `id`=106;
UPDATE `tablefindoptions` SET `search`='invoices.type=\"Order\" and invoicestatuses.name=\"Open\"' WHERE `id`=107;
ALTER TABLE `tax` ADD COLUMN `inactive` TINYINT UNSIGNED DEFAULT 0 AFTER `percentage`;
UPDATE `tabledefs` SET `defaultwhereclause`='tax.inactive=0',`deletebutton`="inactivate" WHERE `maintable`="tax";
DELETE FROM `tablefindoptions` WHERE `tabledefid`=6;
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (6,'All Records','tax.id != 0',3,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (6,'Active Records','tax.inactive=0',1,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (6,'Inactive Records','tax.inactive=1',2,0);
ALTER TABLE `productcategories` ADD COLUMN `inactive` TINYINT UNSIGNED DEFAULT 0 AFTER `name`;
UPDATE `tabledefs` SET `defaultwhereclause`='productcategories.inactive=0',`deletebutton`="inactivate" WHERE `id`=7;
DELETE FROM `tablefindoptions` WHERE `tabledefid`=7;
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (7,'All Records','productcategories.id != 0',3,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (7,'Active Records','productcategories.inactive=0',1,0);
INSERT INTO `tablefindoptions` (`tabledefid`, `name`, `search`, `displayorder`, `roleid`) VALUES (7,'Inactive Records','productcategories.inactive=1',2,0);
UPDATE `tablecolumns` set `column`='invoicestatuses.name' WHERE `column`='invoices.name';

INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('tabgroups','products entry');
INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('tabgroups','clients entry');
INSERT INTO `choices` (`listname`, `thevalue`) VALUES ('tabgroups','invoices entry');
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (6,'general','clients entry','modules/bms/clients_addedit.php',10,1,10,'','',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (7,'purchase history','clients entry','modules/bms/clients_purchasehistory.php',20,0,30,'','',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (8,'attachments','clients entry','modules/bms/clients_attachments.php',30,0,10,'','SELECT count(id) AS theresult FROM attachments WHERE  tabledefid=2 AND recordid={{id}}',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (9,'notes/tasks/events','clients entry','modules/bms/clients_notes.php',40,0,10,'','SELECT count(id) AS theresult FROM notes WHERE attachedtabledefid=2 AND attachedid={{id}}',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (10,'general','products entry','modules/bms/products_addedit.php',10,1,10,'','',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (11,'prerequisites','products entry','modules/bms/products_prereq.php',20,0,10,'','SELECT count(id) FROM prerequisites WHERE childid={{id}}',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (12,'sales history','products entry','modules/bms/products_saleshistory.php',30,0,30,'','',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (13,'attachments','products entry','modules/bms/products_attachments.php',40,0,10,'','SELECT count(id) AS theresult FROM attachments WHERE  tabledefid=4 AND recordid={{id}}',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (14,'notes/tasks/events','products entry','modules/bms/products_notes.php',50,0,10,'','SELECT count(id) AS theresult FROM notes WHERE attachedtabledefid=4 AND attachedid={{id}}',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (15,'general','invoices entry','modules/bms/invoices_addedit.php',10,1,10,'','',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (16,'status history','invoices entry','modules/bms/invoices_statushistory.php',20,0,20,'','',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (17,'attachments','invoices entry','modules/bms/invoices_attachments.php',30,0,10,'','SELECT count(id) AS theresult FROM attachments WHERE  tabledefid=3 AND recordid={{id}}',1,NOW(),1,NOW());
INSERT INTO `tabs` (`id`, `name`, `tabgroup`, `location`, `displayorder`, `enableonnew`, `roleid`, `tooltip`, `notificationsql`, `createdby`, `creationdate`, `modifiedby`, `modifieddate`) VALUES (18,'notes/events/task','invoices entry','modules/bms/invoices_notes.php',40,0,10,'','SELECT count(id) AS theresult FROM notes WHERE attachedtabledefid=3 AND attachedid={{id}}',1,NOW(),1,NOW());