<?php
/*
* 2007-2011 PrestaShop 
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2011 PrestaShop SA
*  @version  Release: $Revision: 7540 $
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class SubDomainCore extends ObjectModel
{
	public $name;

	protected $fieldsRequired = array('name');
	protected $fieldsSize = array('name' => 16);
	protected $fieldsValidate = array('name' => 'isSubDomainName');

	protected $table = 'subdomain';
	protected $identifier = 'id_subdomain';

	public function getFields()
	{
		parent::validateFields();
		$fields['name'] = pSQL($this->name);
		return $fields;
	}

	public static function getSubDomains()
	{
		if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('SELECT `name` FROM `'._DB_PREFIX_.'subdomain`'))
			return false;
		$subDomains = array();
		foreach ($result AS $row)
			$subDomains[] = $row['name'];
		return $subDomains;
	}
}

